package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CspTbPersonPartnerRelReqDto;
import com.dtyunxi.tcbj.api.dto.response.CspTbPersonPartnerRelRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

import java.util.List;

/**
*
*营销云业务员客户关联关系
* @author liguofeng
* @since 2023-01-09
*/
@Api(tags = {"报表中心:营销云业务员客户关联关系"})
@FeignClient(
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/tbPersonPartner",
    url = "${tcbj.center.report.api:}"
)
public interface ICspTbPersonPartnerRelApi {


    /**
     * 批量新增
     *
     * @param addReqDtos 请求对象
     * @return 处理结果
     */
    @PostMapping("/batch/add")
    @ApiOperation(value = "批量新增", notes = "批量新增")
    RestResponse<Void> batchAddCspTbPersonPartnerRel(@RequestBody List<CspTbPersonPartnerRelReqDto> addReqDtos);




    /**
     * 批量删除
     *
     * @param masterOuIdList        删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/batch/deleteByMasterOuId")
    @ApiOperation(value = "批量删除", notes = "批量删除")
    RestResponse<Void> deleteByMasterOuId(@RequestBody List<String> masterOuIdList);


}
