package com.dtyunxi.tcbj.api.biz.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.biz.inventory.dto.QueryExternalSystemCodeReq;
import com.dtyunxi.tcbj.api.biz.inventory.dto.QueryExternalSystemCodeResp;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(tags = "商品查询")
@FeignClient(
        name = "${tcbj.center.inventory.api.name:tcbj-center-inventory}",
        path = "/v1/inventory",
        url = "${tcbj.center.inventory.api:}"
)
public interface IItemQuery2025Api {

    @PostMapping("/queryItemExternalCode")
    @ApiOperation("根据仓库编码和SAP商品编码查询外围系统编码")
    RestResponse<QueryExternalSystemCodeResp> queryItemExternalCode(@RequestBody QueryExternalSystemCodeReq queryDto);
}
