package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ChannelInventoryReqDto;
import com.dtyunxi.tcbj.api.dto.response.ChannelInventoryRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 渠道仓库存表服务接口
*
* @author wude
* @since 2022-03-09
*/
@Api(tags = {"渠道仓库存表服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/channelInventory", url = "${tcbj.center.report.api:}")
public interface IChannelInventoryQueryApi {

    /**
    * 根据id查询渠道仓库存表
    *
    * @param id 渠道仓库存表id
    * @return   渠道仓库存表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询渠道仓库存表", notes = "根据id查询渠道仓库存表")
    RestResponse<ChannelInventoryRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 渠道仓库存表分页数据
    *
    * @param filter   渠道仓库存表查询条件
    * @return 渠道仓库存表分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "渠道仓库存表分页数据", notes = "根据filter查询条件查询渠道仓库存表数据，filter=ChannelInventoryReqDto")
    RestResponse<PageInfo<ChannelInventoryRespDto>> queryByPage(@RequestBody ChannelInventoryReqDto filter);

}
