package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author minyue
 * @description: 经销商报表-免费赠品汇总respDto
 * @since 2022-01-07 15:59
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "OrderItemProductRankingRespDto", description = "经销商报表-免费赠品汇总respDto")
public class FreeGiftSummaryRespDto extends ReportBrandBaseRespDto{

    @ApiModelProperty(name = "beginningOfPeriodQuota", value = "期初额度")
    private BigDecimal beginningOfPeriodQuota;

    @ApiModelProperty(name = "giveReturn", value = "下单赠送")
    private BigDecimal orderGift;

    @ApiModelProperty(name = "giveReturn", value = "赠送退回")
    private BigDecimal giveReturn;

    @ApiModelProperty(name = "freeGiftQuota", value = "赠送额度")
    private BigDecimal freeGiftQuota;

    @ApiModelProperty(name = "advanceGiftQuota", value = "预支额度")
    private BigDecimal advanceGiftQuota;

    @ApiModelProperty(name = "alreadyRepaidAdvanceQuota", value = "已还预支额度")
    private BigDecimal alreadyRepaidAdvanceQuota;

    @ApiModelProperty(name = "chargebackDeductionQuota", value = "退单扣回额度")
    private BigDecimal chargebackDeductionQuota;

    @ApiModelProperty(name = "manualImport", value = "人工导入")
    private BigDecimal manualImport;

    @ApiModelProperty(name = "orderDeduct", value = "订单抵扣")
    private BigDecimal orderDeduct;

    @ApiModelProperty(name = "usedGiftQuota", value = "已使用额度")
    private BigDecimal usedGiftQuota;

    @ApiModelProperty(name = "remainderGiftQuota", value = "剩余赠品额度")
    private BigDecimal remainderGiftQuota;

    @ApiModelProperty(name = "freezeQuota", value = "冻结额度")
    private BigDecimal freezeQuota;

    @ApiModelProperty(name = "allowUseQuota", value = "可用赠品额度")
    private BigDecimal allowUseQuota;

    @ApiModelProperty(name = "parentAreaSum", value = "大区合计")
    private Integer parentAreaSum;

    @ApiModelProperty(name = "customerAreaSum", value = "区域合计")
    private Integer customerAreaSum;

    @ApiModelProperty(name = "orderReturn", value = "订单退回")
    private BigDecimal orderReturn;

    private BigDecimal tradeAmount;

    private String tradeType;
}
