package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckRelationRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 客户关联药店客户信息
 *
 * @author ghosn
 * @create 2023/3/27 15:45
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "CustomerStoreResponseDto",description = "客户门店信息Dto")
public class CustomerStoreResponseDto {

    @ApiModelProperty(
            name = "storeId",
            value = "门店ID"
    )
    private String storeId;

    @ApiModelProperty(
            name = "storeNo",
            value = "门店编码"
    )
    private String storeNo;

    @ApiModelProperty(
            name = "storeNo",
            value = "门店名称"
    )
    private String storeName;

    @ApiModelProperty(
            name = "storeState",
            value = "门店状态"
    )
    private String storeState;

    @ApiModelProperty(
            name = "province",
            value = "省份"
    )
    private String province;

    @ApiModelProperty(
            name = "provinceCode",
            value = "省份编码"
    )
    private String provinceCode;

    @ApiModelProperty(
            name = "city",
            value = "市"
    )
    private String city;

    @ApiModelProperty(
            name = "cityCode",
            value = "市编码"
    )
    private String cityCode;

    @ApiModelProperty(
            name = "district",
            value = "县区"
    )
    private String district;

    @ApiModelProperty(
            name = "districtCode",
            value = "县区编码"
    )
    private String districtCode;

    @ApiModelProperty(
            name = "createTime",
            value = "门店创建时间"
    )
    private Date createTime;

    @ApiModelProperty(
            name = "storeAddr",
            value = "门店地址"
    )
    private String storeAddr;

    @ApiModelProperty(
            name = "socialCreditNum",
            value = "门店信用代码"
    )
    private String socialCreditNum;

    @ApiModelProperty(
            name = "storeType",
            value = "门店类型"
    )
    private String storeType;

    @ApiModelProperty(
            name = "storeCategoryCode",
            value = "门店类别"
    )
    private String storeCategoryCode;

    @ApiModelProperty(
            name = "storeCategoryName",
            value = "门店类别名称"
    )
    private String storeCategoryName;

    @ApiModelProperty(
            name = "distributionName",
            value = "分销商名称"
    )
    private String distributionName;

    @ApiModelProperty(
            name = "distributionCode",
            value = "分销商客户编码"
    )
    private String distributionCode;

    @ApiModelProperty(
            name = "distributionCreditCode",
            value = "分销商信用代码"
    )
    private String distributionCreditCode;

    @ApiModelProperty(
            name = "parentStoreNo",
            value = "父级门店编码"
    )
    private String parentStoreNo;

    @ApiModelProperty(
            name = "parentStoreName",
            value = "父级门店名称"
    )
    private String parentStoreName;

    @ApiModelProperty(
            name = "parentCreditCode",
            value = "父级门店信用代码"
    )
    private String parentCreditCode;

    @ApiModelProperty(
            name = "merchantId",
            value = "组织id"
    )
    private Long merchantId;


    @ApiModelProperty(
            name = "customerType",
            value = "客户数据类型"
    )
    private Integer customerType;

    @ApiModelProperty(
            name = "customerId",
            value = "经销商ID"
    )
    private String customerId;


    @ApiModelProperty(
            name = "customerCheckRelationRespDto",
            value = "考核关系数据"
    )
    private CustomerCheckRelationRespDto customerCheckRelationRespDto;


    @ApiModelProperty(
            name = "showHistoryFlag",
            value = "是否显示修改记录标识(0:不显示 1:显示)"
    )
    private String showHistoryFlag = "0";



    @ApiModelProperty(name = "districtCodeExt", value = "大区编码")
    private String merchantDistrictCodeExt;
    @ApiModelProperty(name = "districtNameExt", value = "大区")
    private String merchantDistrictNameExt;
    @ApiModelProperty(name = "regionCodeExt", value = "区域编码")
    private String merchantRegionCodeExt;
    @ApiModelProperty(name = "regionNameExt", value = "区域")
    private String merchantRegionNameExt;

    @ApiModelProperty(name = "merchantName", value = "经销商名称")
    private String merchantName;
    @ApiModelProperty(name = "merchantCode", value = "经销商编码")
    private String merchantCode;



    @ApiModelProperty(name = "salesmanCode", value = "考核人员编码")
    private String salesmanCode;

    @ApiModelProperty(name = "checkRelationFlag", value = "是否考核 (0:否 1:是)")
    private String checkRelationFlag ="0";

}
