package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@ApiModel(value = "LogicInventoryRespDto", description = "逻辑仓库存响应dto")
@Data
public class PhysicalInventoryRespDto extends ResponseDto {
    /**
     *  物理仓编码
     */
    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓编码")
    private String physicsWarehouseCode;

    /**
     *  物理仓名称
     */
    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓名称")
    private String physicsWarehouseName;
    /**
     *  仓库类型
     */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型")
    private String warehouseType;
    /**
     *  商品长编码
     */
    @ApiModelProperty(name = "itemLongCode", value = "商品长编码")
    private String itemLongCode;
    /**
     *  商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "organizationName", value = "所属组织名称")
    private String organizationName;

    @ApiModelProperty(name = "itemName", value = "线上线下标识，线上-on_line   线下-off_line")
    private String warehouseOnlineFlag;

    @ApiModelProperty(name = "waitInspectionAvailableEnd", value = "待检可用库存")
    private BigDecimal waitInspectionAvailable;


    @ApiModelProperty(name = "available", value = "总可用库存")
    private BigDecimal available;


    @ApiModelProperty(name = "balance", value = "总即时库存")
    private BigDecimal balance;


    @ApiModelProperty(name = "preemptQuery", value = "预占库存")
    private BigDecimal preempt;


    @ApiModelProperty(name = "lockInventory", value = "锁定库存")
    private BigDecimal lockInventory;

    @ApiModelProperty(name = "intransit", value = "在途库存")
    private BigDecimal intransit;

}
