package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.InventoryComparisonReportAddReqDto;
import com.dtyunxi.tcbj.api.dto.request.InventoryComparisonReqDto;
import com.dtyunxi.tcbj.api.dto.response.InventoryComparisonReportRespDto;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.response.InventoryQueryResponseDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
* 库存报表对比服务接口
*
* @author fengjian
* @since 2022-07-07
*/
@Api(tags = {"库存报表对比服务"})
@FeignClient(
    name = "${tcbj.center.report.name:tcbj-center-report}",
    path = "/v1/inventoryComparisonReport",
    url = "${com.dtyunxi.tcbj.api:}"
)
public interface IInventoryComparisonReportQueryApi {

    /**
     * 库存报表对比分页数据
     *
     * @param dto 参数
     * @return 库存报表对比分页数据
     */
    @PostMapping("")
    @ApiOperation(value = "库存报表对比分页数据", notes = "根据filter查询条件查询库存报表对比数据，filter=InventoryComparisonReqDto")
    RestResponse<PageInfo<InventoryComparisonReportRespDto>> queryInventoryReportComparisonReport(@RequestBody InventoryComparisonReqDto dto);

    @PostMapping("/initComparisonData")
    @ApiOperation(value = "初始化报表基础数据", notes = "初始化报表基础数据")
    RestResponse<Integer> initComparisonData();

    @PostMapping("/addWmsReport")
    @ApiOperation(value = "插入wms结存报表", notes = "插入wms结存报表")
    RestResponse<Void> addWmsReport(@RequestBody InventoryQueryResponseDto inventoryQueryResponseDto);

    @GetMapping("/executeJob")
    RestResponse<Void> executeJob();

    @PostMapping("/updateBatch")
    @ApiOperation(value = "批量修改数据", notes = "批量修改数据")
    RestResponse<Void> updateBatch(@RequestBody List<InventoryComparisonReportAddReqDto> updates);
}
