package com.dtyunxi.tcbj.api.dto.constant.enums;

/**
 * @author lius5
 * 账单异常类型枚举
 */
public enum BillExceptionInfoEnum {

    /**  仓储明细异常  */
    STORAGE_SUPPORT_IS_EXCEPTION("1001","SKU板数异常"),
    STORAGE_VOLUME_IS_EXCEPTION("1002","SKU体积异常"),
    STORAGE_PACKING_QUANTITY_IS_EXCEPTION("1003","SKU大包系数异常"),

    /**  仓储账单异常  */

    ORG_SUPPORT_EXCEPTION("1004","对应仓储明细组织月总占板数异常"),
    PHYSICAL_ALL_SUPPORT_EXCEPTION("1005","对应仓储明细物理仓总板数异常"),
    NOT_EXIT_STORAGE_CONTRACT("1006","不存在指定仓储合同"),
    NOT_EXIT_STORAGE_UNIT_PRICE("1007","合同不存在指定月份单价"),
    ORG_VOLUME_EXCEPTION("1008","对应仓储明细组织出库体积异常"),


    ;

    private String code;


    private String desc;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    BillExceptionInfoEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static BillExceptionInfoEnum keyOfEnum(String key) {
        for (BillExceptionInfoEnum billExceptionInfoEnum : BillExceptionInfoEnum.values()) {
            if(billExceptionInfoEnum.getCode().equals(key)){
                return billExceptionInfoEnum;
            }
        }
        return null;
    }
}
