package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author jack
 * @version 1.0
 * @date 02/09/2022 19:17
 **/
@Getter
@Setter
@ApiModel(value = "SkuInventoryReqDto", description = "sku库存统计响应对象")
public class SkuInventoryRespDto {
    @ApiModelProperty(name = "key", value = "提取key")
    private String key;

    @ApiModelProperty(name = "skuCode", value = "货品编码")
    private String skuCode;

    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;

    private Date produceTime;

    @ApiModelProperty(name = "warehouseCode", value = "逻辑仓库编码")
    private String warehouseCode;

    private String warehouseName;


    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓库编码")
    private String physicsWarehouseCode;

    private String physicsWarehouseName;

    @ApiModelProperty(name = "organizationCode", value = "组织编码")
    private String organizationCode;

    private String organizationName;


    @ApiModelProperty(name = "qualifiedInventory", value = "总仓合格可用库存")
    private BigDecimal qualifiedInventory;

    @ApiModelProperty(name = "waitInspInventory", value = "总仓待检可用库存")
    private BigDecimal waitInspInventory;

    @ApiModelProperty(name = "replenishmentInventory", value = "补货可用库存")
    private BigDecimal replenishmentInventory;

    @ApiModelProperty(name = "allInventory", value = "全国可用库存")
    private BigDecimal allInventory;


    @ApiModelProperty(name = "allInventory", value = "可用库存")
    private BigDecimal availableInventory;

    @ApiModelProperty(name = "warehouseQuality", value = "仓库品质")
    private String warehouseQuality;


}
