package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.StorageChargeApportionDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.StorageChargeApportionDetailRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 仓储费用分摊明细表服务接口
*
* @author by_liusong
* @since 2022-07-15
*/
@Api(tags = {"仓储费用分摊明细表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IStorageChargeApportionDetailQueryApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/storageChargeApportionDetail",
    url = "${tcbj.center.report.api:}"
)
public interface IStorageChargeApportionDetailQueryApi {

    /**
    * 根据id查询仓储费用分摊明细表
    *
    * @param id 仓储费用分摊明细表id
    * @return   仓储费用分摊明细表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询仓储费用分摊明细表", notes = "根据id查询仓储费用分摊明细表")
    RestResponse<StorageChargeApportionDetailRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 仓储费用分摊明细表分页数据
    *
    * @param filter   仓储费用分摊明细表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 仓储费用分摊明细表分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "仓储费用分摊明细表分页数据", notes = "根据filter查询条件查询仓储费用分摊明细表数据，filter=StorageChargeApportionDetailReqDto")
    RestResponse<PageInfo<StorageChargeApportionDetailRespDto>> queryByPage(@RequestBody StorageChargeApportionDetailReqDto storageChargeApportionDetailReqDto);

}
