package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;

import javax.persistence.Column;

/**
* 快递费用报表详情Eo对象
*
* @author 天泽
* @since 2022-11-17
*/
@ApiModel(value = "ExpressCostDetailRespDto", description = "快递费用报表详情Eo对象")
public class ExpressCostDetailRespDto extends BaseRespDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  快递费报表ID
    */
    @ApiModelProperty(name = "reportId", value = "快递费报表ID")
    private Long reportId;
    /**
    *  单据类型
    */
    @ApiModelProperty(name = "billType", value = "单据类型")
    private Integer billType;
    /**
    *  记账月份
    */
    @ApiModelProperty(name = "bookkeepingMonth", value = "记账月份")
    private String bookkeepingMonth;
    /**
    *  出库时间
    */
    @ApiModelProperty(name = "outboundTime", value = "出库时间")
    private Date outboundTime;
    /**
    *  出库单号
    */
    @ApiModelProperty(name = "outboundCode", value = "出库单号")
    private String outboundCode;
    /**
    *  WMS出库单号
    */
    @ApiModelProperty(name = "wmsOutboundCode", value = "WMS出库单号")
    private String wmsOutboundCode;
    /**
    *  业务单号
    */
    @ApiModelProperty(name = "businessCode", value = "业务单号")
    private String businessCode;
    /**
    *  业务类型
    */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    /**
    *  物理仓编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "物理仓编码")
    private String warehouseCode;
    /**
    *  物理仓名称
    */
    @ApiModelProperty(name = "warehouseName", value = "物理仓名称")
    private String warehouseName;
    /**
    *  物流公司编码
    */
    @ApiModelProperty(name = "logisticCode", value = "物流公司编码")
    private String logisticCode;
    /**
    *  物流公司名称
    */
    @ApiModelProperty(name = "logisticCompany", value = "物流公司名称")
    private String logisticCompany;
    /**
    *  承运方式
    */
    @ApiModelProperty(name = "transportType", value = "承运方式")
    private String transportType;
    /**
    *  计算方式
    */
    @ApiModelProperty(name = "chargeMode", value = "计算方式")
    private Integer chargeMode;
    /**
    *  快递单号
    */
    @ApiModelProperty(name = "expressNo", value = "快递单号")
    private String expressNo;
    /**
    *  件数
    */
    @ApiModelProperty(name = "pieceNum", value = "件数")
    private Long pieceNum;
    /**
    *  体积重
    */
    @ApiModelProperty(name = "volumeWeight", value = "体积重")
    private BigDecimal volumeWeight;
    /**
    *  重量
    */
    @ApiModelProperty(name = "weight", value = "重量")
    private BigDecimal weight;

    @ApiModelProperty(name = "expressWeight", value = "快递计费重量")
    private BigDecimal expressWeight;

    @ApiModelProperty(name = "chargedWeight", value = "计费重量")
    private BigDecimal chargedWeight;
    /**
    *  重量范围
    */
    @ApiModelProperty(name = "weightRange", value = "重量范围")
    private String weightRange;
    /**
    *  首价
    */
    @ApiModelProperty(name = "firstPrice", value = "首价")
    private BigDecimal firstPrice;
    /**
    *  续价1
    */
    @ApiModelProperty(name = "continuedOne", value = "续价1")
    private BigDecimal continuedOne;
    /**
    *  续价2
    */
    @ApiModelProperty(name = "continuedTwo", value = "续价2")
    private BigDecimal continuedTwo;
    /**
    *  续价3
    */
    @ApiModelProperty(name = "continuedThree", value = "续价3")
    private BigDecimal continuedThree;
    /**
    *  续价4
    */
    @ApiModelProperty(name = "continuedFour", value = "续价4")
    private BigDecimal continuedFour;
    /**
    *  续价运费
    */
    @ApiModelProperty(name = "continuedFreight", value = "续价运费")
    private BigDecimal continuedFreight;
    /**
    *  旺季浮动金额
    */
    @ApiModelProperty(name = "floatAmount", value = "旺季浮动金额")
    private BigDecimal floatAmount;
    /**
    *  包装费
    */
    @ApiModelProperty(name = "packingFreight", value = "包装费")
    private BigDecimal packingFreight;
    /**
    *  增值费
    */
    @ApiModelProperty(name = "incrementFreight", value = "增值费")
    private BigDecimal incrementFreight;
    /**
    *  投保金额
    */
    @ApiModelProperty(name = "insureAmount", value = "投保金额")
    private BigDecimal insureAmount;
    /**
    *  保费
    */
    @ApiModelProperty(name = "premium", value = "保费")
    private BigDecimal premium;
    /**
    *  调整类型
    */
    @ApiModelProperty(name = "adjustmentType", value = "调整类型")
    private String adjustmentType;
    /**
    *  调整金额
    */
    @ApiModelProperty(name = "adjustmentAmount", value = "调整金额")
    private BigDecimal adjustmentAmount;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  运费合计
    */
    @ApiModelProperty(name = "totalFreight", value = "运费合计")
    private BigDecimal totalFreight;
    /**
    *  调出仓编码
    */
    @ApiModelProperty(name = "outWarehouseCode", value = "调出仓编码")
    private String outWarehouseCode;
    /**
    *  调出仓名称
    */
    @ApiModelProperty(name = "outWarehouseName", value = "调出仓名称")
    private String outWarehouseName;
    /**
    *  出仓组织
    */
    @ApiModelProperty(name = "outOrg", value = "出仓组织")
    private String outOrg;
    /**
    *  出仓组织编码
    */
    @ApiModelProperty(name = "outOrgCode", value = "出仓组织编码")
    private String outOrgCode;
    /**
    *  入仓编码
    */
    @ApiModelProperty(name = "inWarehouseCode", value = "入仓编码")
    private String inWarehouseCode;
    /**
    *  入仓名称
    */
    @ApiModelProperty(name = "inWarehouseName", value = "入仓名称")
    private String inWarehouseName;
    /**
    *  入仓组织编码
    */
    @ApiModelProperty(name = "inOrgCode", value = "入仓组织编码")
    private String inOrgCode;
    /**
    *  入仓组织
    */
    @ApiModelProperty(name = "inOrg", value = "入仓组织")
    private String inOrg;
    /**
    *  费用归属
    */
    @ApiModelProperty(name = "freightOrg", value = "费用归属")
    private String freightOrg;
    /**
    *  费用归属编码
    */
    @ApiModelProperty(name = "freightOrgCode", value = "费用归属编码")
    private String freightOrgCode;
    /**
    *  收件人
    */
    @ApiModelProperty(name = "consignee", value = "收件人")
    private String consignee;
    /**
    *  省份
    */
    @ApiModelProperty(name = "province", value = "省份")
    private String province;
    /**
    *  城市
    */
    @ApiModelProperty(name = "city", value = "城市")
    private String city;
    /**
    *  区/县
    */
    @ApiModelProperty(name = "area", value = "区/县")
    private String area;
    /**
    *  经纬度
    */
    @ApiModelProperty(name = "lngLat", value = "经纬度")
    private String lngLat;
    /**
    *  详细地址
    */
    @ApiModelProperty(name = "address", value = "详细地址")
    private String address;
    /**
    *  分摊比例
    */
    @ApiModelProperty(name = "ratio", value = "分摊比例")
    private BigDecimal ratio;
    /**
    *  异常原因
    */
    @ApiModelProperty(name = "abnormalCauses", value = "异常原因")
    private String abnormalCauses;
    /**
    *  异常标识0正常 1异常
    */
    @ApiModelProperty(name = "abnormal", value = "异常标识0正常 1异常")
    private Integer abnormal;
    /**
    *  省市级别
    */
    @ApiModelProperty(name = "cityLevel", value = "省市级别")
    private String cityLevel;
    /**
    *  客户名称
    */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;
    /**
    *  eas编码
    */
    @ApiModelProperty(name = "easNo", value = "eas编码")
    private String easNo;
    /**
    *  开单日期
    */
    @ApiModelProperty(name = "billingDate", value = "开单日期")
    private String billingDate;
    /**
    *  最后修改人
    */
    @ApiModelProperty(name = "lastUpdatePerson", value = "最后修改人")
    private String lastUpdatePerson;
    /**
    *  最后修改时间
    */
    @ApiModelProperty(name = "lastUpdateTime", value = "最后修改时间")
    private Date lastUpdateTime;

    @ApiModelProperty(name = "returnFee", value = "返回费用")
    private BigDecimal returnFee;

    @ApiModelProperty(name = "outDocumentNo", value = "出库通知单号")
    private String outDocumentNo;

    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "出库物理仓")
    private String outPhysicsWarehouseName;

    @ApiModelProperty(name = "contractId", value = "合同id")
    private Long contractId;

    @ApiModelProperty(name = "noBillingReason", value = "不计费原因")
    private String noBillingReason;

    @ApiModelProperty(name = "billingFeeFlag", value = "是否计费,0不计费,1计费")
    private Integer billingFeeFlag;

    @ApiModelProperty(name = "placedFlag", value = "是否已归档,0未归档,1已归档")
    private Integer placedFlag;

    @ApiModelProperty(name = "linkDailyReportId", value = "关联每日发货报表记录id")
    private Long linkDailyReportId;

    @ApiModelProperty(name = "wmsMergeDocumentNo", value = "wms合单号")
    private String wmsMergeDocumentNo;

    @ApiModelProperty(name = "joinMergeDocumentNo", value = "加入合单号")
    private String joinMergeDocumentNo;

    @ApiModelProperty(name = "expressBackRemake", value = "快递回传重量")
    private BigDecimal expressBackRemake;

    @ApiModelProperty(name = "weightDifference", value = "重量差异（快递回传重量-ocs重量）")
    private BigDecimal weightDifference;

    @ApiModelProperty(name = "e3No", value = "E3单号")
    private String e3No;

    @ApiModelProperty(name = "outNoticeNo", value = "出库通知单单号")
    private String outNoticeNo;

    @ApiModelProperty(name = "consignmentNo", value = "托运单号")
    private String consignmentNo;

    @ApiModelProperty(name = "ocsSystemWeight", value = "OCS系统重量")
    private BigDecimal ocsSystemWeight;

    @ApiModelProperty(name = "beginDeliverProvince", value = "始发省")
    private String beginDeliverProvince;

    @ApiModelProperty(name = "beginDeliverProvinceCode", value = "始发省编码")
    private String beginDeliverProvinceCode;

    @ApiModelProperty(name = "beginDeliverCity", value = "始发城市")
    private String beginDeliverCity;

    @ApiModelProperty(name = "beginDeliverCityCode", value = "始发城市编码")
    private String beginDeliverCityCode;

    @ApiModelProperty(name = "ifRepeat", value = "是否重复，1是 0否")
    private Integer ifRepeat;

    @ApiModelProperty(name = "masterOrder", value = "是否总单，1是 0否")
    private Integer masterOrder;

    @ApiModelProperty(name = "shopName", value = "店铺")
    private String shopName;

    @ApiModelProperty(name = "shopCode", value = "店铺编码")
    private String shopCode;

    @ApiModelProperty(name = "volume", value = "体积")
    private BigDecimal volume;

    @ApiModelProperty(name = "volumeRemark", value = "体积备注")
    private String volumeRemark;

    @ApiModelProperty(name = "firstPricePer", value = "首价单价")
    private BigDecimal firstPricePer;

    @ApiModelProperty(name = "continuedOnePer", value = "续价1单价")
    private BigDecimal continuedOnePer;

    @ApiModelProperty(name = "continuedTwoPer", value = "续价单价")
    private BigDecimal continuedTwoPer;

    @ApiModelProperty(name = "continuedThreePer", value = "续价3单价")
    private BigDecimal continuedThreePer;

    @ApiModelProperty(name = "continuedFourPer", value = "续价4单价")
    private BigDecimal continuedFourPer;

    public BigDecimal getFirstPricePer() {
        return firstPricePer;
    }

    public void setFirstPricePer(BigDecimal firstPricePer) {
        this.firstPricePer = firstPricePer;
    }

    public BigDecimal getContinuedOnePer() {
        return continuedOnePer;
    }

    public void setContinuedOnePer(BigDecimal continuedOnePer) {
        this.continuedOnePer = continuedOnePer;
    }

    public BigDecimal getContinuedTwoPer() {
        return continuedTwoPer;
    }

    public void setContinuedTwoPer(BigDecimal continuedTwoPer) {
        this.continuedTwoPer = continuedTwoPer;
    }

    public BigDecimal getContinuedThreePer() {
        return continuedThreePer;
    }

    public void setContinuedThreePer(BigDecimal continuedThreePer) {
        this.continuedThreePer = continuedThreePer;
    }

    public BigDecimal getContinuedFourPer() {
        return continuedFourPer;
    }

    public void setContinuedFourPer(BigDecimal continuedFourPer) {
        this.continuedFourPer = continuedFourPer;
    }

    public String getVolumeRemark() {
        return volumeRemark;
    }

    public void setVolumeRemark(String volumeRemark) {
        this.volumeRemark = volumeRemark;
    }

    public BigDecimal getVolume() {
        return volume;
    }

    public void setVolume(BigDecimal volume) {
        this.volume = volume;
    }

    public BigDecimal getWeightDifference() {
        return weightDifference;
    }

    public void setWeightDifference(BigDecimal weightDifference) {
        this.weightDifference = weightDifference;
    }

    public String getE3No() {
        return e3No;
    }

    public void setE3No(String e3No) {
        this.e3No = e3No;
    }

    public String getOutNoticeNo() {
        return outNoticeNo;
    }

    public void setOutNoticeNo(String outNoticeNo) {
        this.outNoticeNo = outNoticeNo;
    }

    public String getConsignmentNo() {
        return consignmentNo;
    }

    public void setConsignmentNo(String consignmentNo) {
        this.consignmentNo = consignmentNo;
    }

    public BigDecimal getOcsSystemWeight() {
        return ocsSystemWeight;
    }

    public void setOcsSystemWeight(BigDecimal ocsSystemWeight) {
        this.ocsSystemWeight = ocsSystemWeight;
    }

    public String getBeginDeliverProvince() {
        return beginDeliverProvince;
    }

    public void setBeginDeliverProvince(String beginDeliverProvince) {
        this.beginDeliverProvince = beginDeliverProvince;
    }

    public String getBeginDeliverProvinceCode() {
        return beginDeliverProvinceCode;
    }

    public void setBeginDeliverProvinceCode(String beginDeliverProvinceCode) {
        this.beginDeliverProvinceCode = beginDeliverProvinceCode;
    }

    public String getBeginDeliverCity() {
        return beginDeliverCity;
    }

    public void setBeginDeliverCity(String beginDeliverCity) {
        this.beginDeliverCity = beginDeliverCity;
    }

    public String getBeginDeliverCityCode() {
        return beginDeliverCityCode;
    }

    public void setBeginDeliverCityCode(String beginDeliverCityCode) {
        this.beginDeliverCityCode = beginDeliverCityCode;
    }

    public Integer getIfRepeat() {
        return ifRepeat;
    }

    public void setIfRepeat(Integer ifRepeat) {
        this.ifRepeat = ifRepeat;
    }

    public Integer getMasterOrder() {
        return masterOrder;
    }

    public void setMasterOrder(Integer masterOrder) {
        this.masterOrder = masterOrder;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public String getShopCode() {
        return shopCode;
    }

    public void setShopCode(String shopCode) {
        this.shopCode = shopCode;
    }

    public BigDecimal getExpressBackRemake() {
        return expressBackRemake;
    }

    public void setExpressBackRemake(BigDecimal expressBackRemake) {
        this.expressBackRemake = expressBackRemake;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getOutDocumentNo() {
        return outDocumentNo;
    }

    public void setOutDocumentNo(String outDocumentNo) {
        this.outDocumentNo = outDocumentNo;
    }

    public String getOutPhysicsWarehouseName() {
        return outPhysicsWarehouseName;
    }

    public void setOutPhysicsWarehouseName(String outPhysicsWarehouseName) {
        this.outPhysicsWarehouseName = outPhysicsWarehouseName;
    }

    public BigDecimal getReturnFee() {
        return returnFee;
    }

    public void setReturnFee(BigDecimal returnFee) {
        this.returnFee = returnFee;
    }

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setReportId(Long reportId){
    this.reportId = reportId;
    }
    public Long getReportId(){
    return this.reportId;
    }
    public void setBillType(Integer billType){
    this.billType = billType;
    }
    public Integer getBillType(){
    return this.billType;
    }
    public void setBookkeepingMonth(String bookkeepingMonth){
    this.bookkeepingMonth = bookkeepingMonth;
    }
    public String getBookkeepingMonth(){
    return this.bookkeepingMonth;
    }
    public void setOutboundTime(Date outboundTime){
    this.outboundTime = outboundTime;
    }
    public Date getOutboundTime(){
    return this.outboundTime;
    }
    public void setOutboundCode(String outboundCode){
    this.outboundCode = outboundCode;
    }
    public String getOutboundCode(){
    return this.outboundCode;
    }
    public void setWmsOutboundCode(String wmsOutboundCode){
    this.wmsOutboundCode = wmsOutboundCode;
    }
    public String getWmsOutboundCode(){
    return this.wmsOutboundCode;
    }
    public void setBusinessCode(String businessCode){
    this.businessCode = businessCode;
    }
    public String getBusinessCode(){
    return this.businessCode;
    }
    public void setBusinessType(String businessType){
    this.businessType = businessType;
    }
    public String getBusinessType(){
    return this.businessType;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setLogisticCode(String logisticCode){
    this.logisticCode = logisticCode;
    }
    public String getLogisticCode(){
    return this.logisticCode;
    }
    public void setLogisticCompany(String logisticCompany){
    this.logisticCompany = logisticCompany;
    }
    public String getLogisticCompany(){
    return this.logisticCompany;
    }
    public void setTransportType(String transportType){
    this.transportType = transportType;
    }
    public String getTransportType(){
    return this.transportType;
    }
    public void setChargeMode(Integer chargeMode){
    this.chargeMode = chargeMode;
    }
    public Integer getChargeMode(){
    return this.chargeMode;
    }
    public void setExpressNo(String expressNo){
    this.expressNo = expressNo;
    }
    public String getExpressNo(){
    return this.expressNo;
    }
    public void setPieceNum(Long pieceNum){
    this.pieceNum = pieceNum;
    }
    public Long getPieceNum(){
    return this.pieceNum;
    }
    public void setVolumeWeight(BigDecimal volumeWeight){
    this.volumeWeight = volumeWeight;
    }
    public BigDecimal getVolumeWeight(){
    return this.volumeWeight;
    }
    public void setWeight(BigDecimal weight){
    this.weight = weight;
    }
    public BigDecimal getWeight(){
    return this.weight;
    }
    public void setWeightRange(String weightRange){
    this.weightRange = weightRange;
    }
    public String getWeightRange(){
    return this.weightRange;
    }
    public void setFirstPrice(BigDecimal firstPrice){
    this.firstPrice = firstPrice;
    }
    public BigDecimal getFirstPrice(){
    return this.firstPrice;
    }
    public void setContinuedOne(BigDecimal continuedOne){
    this.continuedOne = continuedOne;
    }
    public BigDecimal getContinuedOne(){
    return this.continuedOne;
    }
    public void setContinuedTwo(BigDecimal continuedTwo){
    this.continuedTwo = continuedTwo;
    }
    public BigDecimal getContinuedTwo(){
    return this.continuedTwo;
    }
    public void setContinuedThree(BigDecimal continuedThree){
    this.continuedThree = continuedThree;
    }
    public BigDecimal getContinuedThree(){
    return this.continuedThree;
    }
    public void setContinuedFour(BigDecimal continuedFour){
    this.continuedFour = continuedFour;
    }
    public BigDecimal getContinuedFour(){
    return this.continuedFour;
    }
    public void setContinuedFreight(BigDecimal continuedFreight){
    this.continuedFreight = continuedFreight;
    }
    public BigDecimal getContinuedFreight(){
    return this.continuedFreight;
    }
    public void setFloatAmount(BigDecimal floatAmount){
    this.floatAmount = floatAmount;
    }
    public BigDecimal getFloatAmount(){
    return this.floatAmount;
    }
    public void setPackingFreight(BigDecimal packingFreight){
    this.packingFreight = packingFreight;
    }
    public BigDecimal getPackingFreight(){
    return this.packingFreight;
    }
    public void setIncrementFreight(BigDecimal incrementFreight){
    this.incrementFreight = incrementFreight;
    }
    public BigDecimal getIncrementFreight(){
    return this.incrementFreight;
    }

    public BigDecimal getInsureAmount() {
        return insureAmount;
    }

    public void setInsureAmount(BigDecimal insureAmount) {
        this.insureAmount = insureAmount;
    }

    public void setPremium(BigDecimal premium){
    this.premium = premium;
    }
    public BigDecimal getPremium(){
    return this.premium;
    }
    public void setAdjustmentType(String adjustmentType){
    this.adjustmentType = adjustmentType;
    }
    public String getAdjustmentType(){
    return this.adjustmentType;
    }
    public void setAdjustmentAmount(BigDecimal adjustmentAmount){
    this.adjustmentAmount = adjustmentAmount;
    }
    public BigDecimal getAdjustmentAmount(){
    return this.adjustmentAmount;
    }
    public void setRemark(String remark){
    this.remark = remark;
    }
    public String getRemark(){
    return this.remark;
    }
    public void setTotalFreight(BigDecimal totalFreight){
    this.totalFreight = totalFreight;
    }
    public BigDecimal getTotalFreight(){
    return this.totalFreight;
    }
    public void setOutWarehouseCode(String outWarehouseCode){
    this.outWarehouseCode = outWarehouseCode;
    }
    public String getOutWarehouseCode(){
    return this.outWarehouseCode;
    }
    public void setOutWarehouseName(String outWarehouseName){
    this.outWarehouseName = outWarehouseName;
    }
    public String getOutWarehouseName(){
    return this.outWarehouseName;
    }
    public void setOutOrg(String outOrg){
    this.outOrg = outOrg;
    }
    public String getOutOrg(){
    return this.outOrg;
    }
    public void setOutOrgCode(String outOrgCode){
    this.outOrgCode = outOrgCode;
    }
    public String getOutOrgCode(){
    return this.outOrgCode;
    }
    public void setInWarehouseCode(String inWarehouseCode){
    this.inWarehouseCode = inWarehouseCode;
    }
    public String getInWarehouseCode(){
    return this.inWarehouseCode;
    }
    public void setInWarehouseName(String inWarehouseName){
    this.inWarehouseName = inWarehouseName;
    }
    public String getInWarehouseName(){
    return this.inWarehouseName;
    }
    public void setInOrgCode(String inOrgCode){
    this.inOrgCode = inOrgCode;
    }
    public String getInOrgCode(){
    return this.inOrgCode;
    }
    public void setInOrg(String inOrg){
    this.inOrg = inOrg;
    }
    public String getInOrg(){
    return this.inOrg;
    }
    public void setFreightOrg(String freightOrg){
    this.freightOrg = freightOrg;
    }
    public String getFreightOrg(){
    return this.freightOrg;
    }
    public void setFreightOrgCode(String freightOrgCode){
    this.freightOrgCode = freightOrgCode;
    }
    public String getFreightOrgCode(){
    return this.freightOrgCode;
    }
    public void setConsignee(String consignee){
    this.consignee = consignee;
    }
    public String getConsignee(){
    return this.consignee;
    }
    public void setProvince(String province){
    this.province = province;
    }
    public String getProvince(){
    return this.province;
    }
    public void setCity(String city){
    this.city = city;
    }
    public String getCity(){
    return this.city;
    }
    public void setArea(String area){
    this.area = area;
    }
    public String getArea(){
    return this.area;
    }
    public void setLngLat(String lngLat){
    this.lngLat = lngLat;
    }
    public String getLngLat(){
    return this.lngLat;
    }
    public void setAddress(String address){
    this.address = address;
    }
    public String getAddress(){
    return this.address;
    }
    public void setRatio(BigDecimal ratio){
    this.ratio = ratio;
    }
    public BigDecimal getRatio(){
    return this.ratio;
    }
    public void setAbnormalCauses(String abnormalCauses){
    this.abnormalCauses = abnormalCauses;
    }
    public String getAbnormalCauses(){
    return this.abnormalCauses;
    }
    public void setAbnormal(Integer abnormal){
    this.abnormal = abnormal;
    }
    public Integer getAbnormal(){
    return this.abnormal;
    }
    public void setCityLevel(String cityLevel){
    this.cityLevel = cityLevel;
    }
    public String getCityLevel(){
    return this.cityLevel;
    }
    public void setCustomerName(String customerName){
    this.customerName = customerName;
    }
    public String getCustomerName(){
    return this.customerName;
    }
    public void setEasNo(String easNo){
    this.easNo = easNo;
    }
    public String getEasNo(){
    return this.easNo;
    }
    public void setBillingDate(String billingDate){
    this.billingDate = billingDate;
    }
    public String getBillingDate(){
    return this.billingDate;
    }
    public void setLastUpdatePerson(String lastUpdatePerson){
    this.lastUpdatePerson = lastUpdatePerson;
    }
    public String getLastUpdatePerson(){
    return this.lastUpdatePerson;
    }
    public void setLastUpdateTime(Date lastUpdateTime){
    this.lastUpdateTime = lastUpdateTime;
    }
    public Date getLastUpdateTime(){
    return this.lastUpdateTime;
    }

    public BigDecimal getExpressWeight() {
        return expressWeight;
    }

    public void setExpressWeight(BigDecimal expressWeight) {
        this.expressWeight = expressWeight;
    }

    public BigDecimal getChargedWeight() {
        return chargedWeight;
    }

    public void setChargedWeight(BigDecimal chargedWeight) {
        this.chargedWeight = chargedWeight;
    }

    public String getNoBillingReason() {
        return noBillingReason;
    }

    public void setNoBillingReason(String noBillingReason) {
        this.noBillingReason = noBillingReason;
    }

    public Integer getBillingFeeFlag() {
        return billingFeeFlag;
    }

    public void setBillingFeeFlag(Integer billingFeeFlag) {
        this.billingFeeFlag = billingFeeFlag;
    }

    public Integer getPlacedFlag() {
        return placedFlag;
    }

    public void setPlacedFlag(Integer placedFlag) {
        this.placedFlag = placedFlag;
    }

    public Long getLinkDailyReportId() {
        return linkDailyReportId;
    }

    public void setLinkDailyReportId(Long linkDailyReportId) {
        this.linkDailyReportId = linkDailyReportId;
    }

    public String getWmsMergeDocumentNo() {
        return wmsMergeDocumentNo;
    }

    public void setWmsMergeDocumentNo(String wmsMergeDocumentNo) {
        this.wmsMergeDocumentNo = wmsMergeDocumentNo;
    }

    public String getJoinMergeDocumentNo() {
        return joinMergeDocumentNo;
    }

    public void setJoinMergeDocumentNo(String joinMergeDocumentNo) {
        this.joinMergeDocumentNo = joinMergeDocumentNo;
    }
}
