package com.dtyunxi.tcbj.api.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;

import java.util.Date;

/**
 * 仓储明细变更导入
 * @author lius5
 */
@ApiModel(value = "ImportStorageChargeDetailChangeVo", description = "仓储明细变更导入Dto对象")
public class ImportStorageChargeDetailChangeErrorVo extends RequestDto {

    /**
     *  统计日期
     */
    @Excel(
            name = "*日期",
            format = DateUtil.YMD_DATA
    )
    private String storageTime;

    /**
     *  仓库编码
     */
    @Excel(
            name = "*物理仓编码"
    )
    private String warehouseCode;

    /**
     *  逻辑仓编码
     */
    @Excel(
            name = "*逻辑仓编码"
    )
    private String logicWarehouseCode;

    /**
     *  商品长码
     */
    @Excel(
            name = "*商品长编码"
    )
    private String opLongCode;

    /**
     *  批次
     */
    @Excel(
            name = "*批次"
    )
    private String batch;

    /**
     *  调整类型；0：减少 1：增加
     */
    @Excel(
            name = "*调整类型",replace = {"减少_0","增加_1"}
    )
    private Integer adjustType;

    /**
     *  调整库存数
     */
    @Excel(name = "*调整数量")
    private Integer adjustDeliveryNum;

    /**
     *  备注
     */
    @Excel(name = "备注")
    private String remark;

    @Excel(name = "错误原因")
    private String result;

    public String getStorageTime() {
        return storageTime;
    }

    public void setStorageTime(String storageTime) {
        this.storageTime = storageTime;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getLogicWarehouseCode() {
        return logicWarehouseCode;
    }

    public void setLogicWarehouseCode(String logicWarehouseCode) {
        this.logicWarehouseCode = logicWarehouseCode;
    }

    public String getOpLongCode() {
        return opLongCode;
    }

    public void setOpLongCode(String opLongCode) {
        this.opLongCode = opLongCode;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public Integer getAdjustType() {
        return adjustType;
    }

    public void setAdjustType(Integer adjustType) {
        this.adjustType = adjustType;
    }

    public Integer getAdjustDeliveryNum() {
        return adjustDeliveryNum;
    }

    public void setAdjustDeliveryNum(Integer adjustDeliveryNum) {
        this.adjustDeliveryNum = adjustDeliveryNum;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }
}
