package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.StoreSearchReqDto;
import com.dtyunxi.tcbj.api.dto.response.ItBrandDto;
import com.dtyunxi.tcbj.api.dto.response.StoreSearchRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@Api(tags = {"报表中心：药店查询接口"})
@FeignClient(
        name = "${com.dtyunxi.tcbj.api.name:tcbj-center-report}",
        path = "/v1/store",
        url = "${tcbj.center.report.api:}"
)
public interface IStoreSearchQueryApi {

    /**
     * 分页查询药店信息
     *
     * @param queryReqDto 查询参数
     * @return RestResponse<PageInfo<StoreSearchRespDto>>
     */
    @PostMapping(value = {"/queryStoreListSearch"}, produces = "application/json")
    @ApiOperation(value = "分页查询药店信息", notes = "分页查询药店信息")
    RestResponse<PageInfo<StoreSearchRespDto>> queryStoreListSearch(@RequestBody StoreSearchReqDto queryReqDto);

    /**
     * 查询所有品牌信息订单
     *
     * @param
     * @return RestResponse<List<ItBrandDto>>
     */
    @GetMapping(value = {"/queryBrands"}, produces = "application/json")
    @ApiOperation(value = "查询所有品牌信息", notes = "查询所有品牌信息")
    RestResponse<List<ItBrandDto>> queryBrands();

}
