package com.dtyunxi.tcbj.api.dto.request;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiModelProperty;
import liquibase.pro.packaged.T;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author minyue
 * @description:
 * @since 2022-01-06 10:16
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ReportBaseReqDto extends PageInfo<ReportBaseReqDto> {

    @ApiModelProperty(name = "organizationIds", value = "品牌(暂时先传大b的组织id),支持多个")
    private List<Long> organizationIds;

    @ApiModelProperty(name = "parentAreaName", value = "大区")
    private List<String> parentAreaCodes;

    @ApiModelProperty(name = "customerAreaName", value = "区域")
    private List<String> customerAreaCodes;

    @ApiModelProperty(name = "customerName", value = "客户")
    private String customerName;

    @ApiModelProperty(name = "column", value = "排序字段")
    private String column;

    @ApiModelProperty(name = "orderBy", value = "正序1, 倒叙0")
    private Integer orderBy;

//    @ApiModelProperty(name = "pageNum", value = "页数")
//    private Integer pageNum = 1;
//
//    @ApiModelProperty(name = "pageSize", value = "每页数量")
//    private Integer pageSize = 10;

    @ApiModelProperty(name = "placeTimeStart", value = "开始时间")
    private String placeTimeStart;

    @ApiModelProperty(name = "placeTimeEnd", value = "结束时间")
    private String placeTimeEnd;
}
