package com.dtyunxi.tcbj.api.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class ChannelInventoryReportRespVo {

    @ApiModelProperty(name = "id", value = "渠道仓库存主键ID")
    private Long id;

    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;

    private Long channelWarehouseId;

    @ApiModelProperty(name = "channelWarehouseCode", value = "渠道仓编码")
    private String channelWarehouseCode;

    @ApiModelProperty(name = "channelWarehouseName", value = "渠道仓名称")
    private String channelWarehouseName;

    @ApiModelProperty(name = "logicBalance", value = "逻辑仓即时")
    private BigDecimal logicBalance;

    @ApiModelProperty(name = "logicAvailable", value = "逻辑仓可用")
    private BigDecimal logicAvailable;

    @ApiModelProperty(name = "logicLockInventory", value = "逻辑仓锁定库存")
    private BigDecimal logicLockInventory;

    @ApiModelProperty(name = "logicPreempt", value = "逻辑仓预占")
    private BigDecimal logicPreempt;

    @ApiModelProperty(name = "logicSalePreempt", value = "逻辑仓销售预占")
    private BigDecimal logicSalePreempt;

    @ApiModelProperty(name = "logicOtherPreempt", value = "逻辑仓其他预占")
    private BigDecimal logicOtherPreempt;

    @ApiModelProperty(name = "virtualPreempt", value = "供货仓预占数")
    private BigDecimal virtualPreempt;

    @ApiModelProperty(name = "notXyPreempt", value = "未寻源预占数")
    private BigDecimal notXyPreempt;

    @ApiModelProperty(name = "logicLessAvailable", value = "逻辑仓剩余可用")
    private BigDecimal logicLessAvailable;

    @ApiModelProperty(name = "channelAvailable", value = "渠道仓可用")
    private BigDecimal channelAvailable;

    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    @ApiModelProperty(name = "remarkFlag", value = "备注标记（0：无标记，1：逻辑仓出库，2：异常）")
    private Integer remarkFlag;
}
