package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.tcbj.api.dto.entity.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.web.bind.annotation.RequestBody;

import java.math.BigDecimal;
import java.util.List;

/**
* 出/入库通知单明细Eo对象
*
* @author 天泽
* @since 2022-08-30
*/
@ApiModel(value = "CsOutNoticeOrderDetailReqDto", description = "出/入库通知单明细Eo对象")
@Getter
@Setter
public class CsOutNoticeOrderDetailReqDto extends BasePageDto {
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  出/入库通知单号
    */
    @ApiModelProperty(name = "documentNo", value = "出/入库通知单号")
    private String documentNo;

    @ApiModelProperty(name = "stringCodeFlag", value = "获取串码校验未通过")
    private Integer stringCodeFlag;

    /**
    *  关联单据号
    */
    @ApiModelProperty(name = "relevanceNo", value = "关联单据号")
    private String relevanceNo;
    /**
    *  前置单号
    */
    @ApiModelProperty(name = "preOrderNo", value = "前置单号")
    private String preOrderNo;
    /**
    *  第三方单据号
    */
    @ApiModelProperty(name = "externalOrderNo", value = "第三方单据号")
    private String externalOrderNo;

    private List<String> orderNos;
    private List<String> externalOrderNos;
    /**
     *  关联单据号
     */
    @ApiModelProperty(name = "relevanceNoList", value = "关联单据号")
    private List<String> relevanceNoList;
    /**
    *  wms单号
    */
    @ApiModelProperty(name = "wmsOrderNo", value = "wms单号")
    private String wmsOrderNo;
    /**
    *  货品ID
    */
    @ApiModelProperty(name = "cargoId", value = "货品ID")
    private Long cargoId;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
    *  货品编码
    */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;
    /**
    *  货品名称
    */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
    *  货品货号
    */
    @ApiModelProperty(name = "artNo", value = "货品货号")
    private String artNo;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;
    /**
    *  原始计划出/入库数量
    */
    @ApiModelProperty(name = "originPlanQuantity", value = "原始计划出/入库数量")
    private BigDecimal originPlanQuantity;
    /**
    *  计划出/入库数量
    */
    @ApiModelProperty(name = "planQuantity", value = "计划出/入库数量")
    private BigDecimal planQuantity;
    /**
    *  待出/入库数量
    */
    @ApiModelProperty(name = "waitQuantity", value = "待出/入库数量")
    private BigDecimal waitQuantity;
    /**
    *  已出/入库数量
    */
    @ApiModelProperty(name = "doneQuantity", value = "已出/入库数量")
    private BigDecimal doneQuantity;
    /**
    *  取消总数量
    */
    @ApiModelProperty(name = "cancelQuantity", value = "取消总数量")
    private BigDecimal cancelQuantity;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    /**
    *  活动ID,只有是活动类型的商品才有值
    */
    @ApiModelProperty(name = "activityId", value = "活动ID,只有是活动类型的商品才有值")
    private Long activityId;

    @ApiModelProperty(name = "easVerifyTimeStartDate", value = "eas财审开始时间")
    private Date easVerifyTimeStartDate;
    @ApiModelProperty(name = "easVerifyTimeEndDate", value = "eas财审结束时间")
    private Date easVerifyTimeEndDate;
}
