package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 药店查询返回对象的Dto
 * @author haoyang
 * @date : 2022/01/08 16:07
 * @since 1.0.0
 */
@ApiModel(value = "StoreSearchRespDto", description = "药店查询返回对象Dto")
public class StoreSearchRespDto extends BaseVo {
    @ApiModelProperty(name = "id", value = "主键id")
    private String id;

    @ApiModelProperty(name = "storeId", value = "机构id")
    private String storeId;

    @ApiModelProperty(name = "storeName", value = "药店名称（机构名称）")
    private String storeName;

    @ApiModelProperty(name = "storeAlias", value = "机构曾用名")
    private String storeAlias;

    @ApiModelProperty(name = "socialCreditNum", value = "信用代码")
    private String socialCreditNum;

    @ApiModelProperty(name = "ifCustomer", value = "是否客户 1：是 0：否")
    private Integer ifCustomer;

    @ApiModelProperty(name = "customerCode", value = "客户编号")
    private String customerCode;

    @ApiModelProperty(name = "storeType", value = "药店分类")
    private String storeType;

    @ApiModelProperty(name = "storeParentName", value = "上级公司(上级总部名称)")
    private String storeParentName;

    @ApiModelProperty(name = "parentSocialCreditNum", value = "上级信用代码(上级总部社会信用代码)")
    private String parentSocialCreditNum;

    @ApiModelProperty(name = "ifParentCustomer", value = "上级是否客户 1：是 0：否")
    private Integer ifParentCustomer;

    @ApiModelProperty(name = "parentCustomerCode", value = "上级客户编号")
    private String parentCustomerCode;

    @ApiModelProperty(name = "parentDistributionName", value = "上级分销商")
    private String parentDistributionName;

    @ApiModelProperty(name = "distributionCreditCode", value = "分销商信用代码")
    private String distributionCreditCode;

    @ApiModelProperty(name = "distributionCustomerCode", value = "分销商客户编号")
    private String distributionCustomerCode;

    @ApiModelProperty(name = "province", value = "所属省份")
    private String province;

    @ApiModelProperty(name = "provinceCode", value = "所属省份code")
    private String provinceCode;

    @ApiModelProperty(name = "city", value = "所属城市")
    private String city;

    @ApiModelProperty(name = "cityCode", value = "所属城市code")
    private String cityCode;

    @ApiModelProperty(name = "district", value = "所属区县")
    private String district;

    @ApiModelProperty(name = "districtCode", value = "所属区县code")
    private String districtCode;

    @ApiModelProperty(name = "storeAddr", value = "详细地址")
    private String storeAddr;

    @ApiModelProperty(name = "isChain", value = "是否连锁药店")
    private String isChain;

    @ApiModelProperty(name = "dbln", value = "药品经营许可证")
    private String dbln;

    @ApiModelProperty(name = "isInsurance", value = "是否医保药店")
    private String isInsurance;

    @ApiModelProperty(name = "state", value = "状态")
    private String state;

    @ApiModelProperty(name = "ifSupply", value = "是否供货 1：是 0：否")
    private Integer ifSupply = 0;

    @ApiModelProperty(name = "brand", value = "品牌编码")
    private String brand;

    @ApiModelProperty(name = "brands", value = "品牌编码数组")
    private List<String> brandCodes;
    @ApiModelProperty(name = "brandNames", value = "品牌名称，多个以斜杠/分割")
    private String brandNames;

    @ApiModelProperty(name = "storeCategoryCode", value = "药店类别CODE")
    private String storeCategoryCode;

    @ApiModelProperty(name = "storeCategoryName", value = "药店类别NAME")
    private String storeCategoryName;

    public String getStoreCategoryCode() {
        return storeCategoryCode;
    }

    public void setStoreCategoryCode(String storeCategoryCode) {
        this.storeCategoryCode = storeCategoryCode;
    }

    public String getStoreCategoryName() {
        return storeCategoryName;
    }

    public void setStoreCategoryName(String storeCategoryName) {
        this.storeCategoryName = storeCategoryName;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getStoreId() {
        return storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getStoreAlias() {
        return storeAlias;
    }

    public void setStoreAlias(String storeAlias) {
        this.storeAlias = storeAlias;
    }

    public String getSocialCreditNum() {
        return socialCreditNum;
    }

    public void setSocialCreditNum(String socialCreditNum) {
        this.socialCreditNum = socialCreditNum;
    }

    public Integer getIfCustomer() {
        return ifCustomer;
    }

    public void setIfCustomer(Integer ifCustomer) {
        this.ifCustomer = ifCustomer;
    }

    public String getCustomerCode() {
        return customerCode;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public String getStoreType() {
        return storeType;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    public String getStoreParentName() {
        return storeParentName;
    }

    public void setStoreParentName(String storeParentName) {
        this.storeParentName = storeParentName;
    }

    public String getParentSocialCreditNum() {
        return parentSocialCreditNum;
    }

    public void setParentSocialCreditNum(String parentSocialCreditNum) {
        this.parentSocialCreditNum = parentSocialCreditNum;
    }

    public Integer getIfParentCustomer() {
        return ifParentCustomer;
    }

    public void setIfParentCustomer(Integer ifParentCustomer) {
        this.ifParentCustomer = ifParentCustomer;
    }

    public String getParentCustomerCode() {
        return parentCustomerCode;
    }

    public void setParentCustomerCode(String parentCustomerCode) {
        this.parentCustomerCode = parentCustomerCode;
    }

    public String getParentDistributionName() {
        return parentDistributionName;
    }

    public void setParentDistributionName(String parentDistributionName) {
        this.parentDistributionName = parentDistributionName;
    }

    public String getDistributionCreditCode() {
        return distributionCreditCode;
    }

    public void setDistributionCreditCode(String distributionCreditCode) {
        this.distributionCreditCode = distributionCreditCode;
    }

    public String getDistributionCustomerCode() {
        return distributionCustomerCode;
    }

    public void setDistributionCustomerCode(String distributionCustomerCode) {
        this.distributionCustomerCode = distributionCustomerCode;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getDistrictCode() {
        return districtCode;
    }

    public void setDistrictCode(String districtCode) {
        this.districtCode = districtCode;
    }

    public String getStoreAddr() {
        return storeAddr;
    }

    public void setStoreAddr(String storeAddr) {
        this.storeAddr = storeAddr;
    }

    public String getIsChain() {
        return isChain;
    }

    public void setIsChain(String isChain) {
        this.isChain = isChain;
    }

    public String getDbln() {
        return dbln;
    }

    public void setDbln(String dbln) {
        this.dbln = dbln;
    }

    public String getIsInsurance() {
        return isInsurance;
    }

    public void setIsInsurance(String isInsurance) {
        this.isInsurance = isInsurance;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Integer getIfSupply() {
        return ifSupply;
    }

    public void setIfSupply(Integer ifSupply) {
        this.ifSupply = ifSupply;
    }

    public String getBrandNames() {
        return brandNames;
    }

    public void setBrandNames(String brandNames) {
        this.brandNames = brandNames;
    }

    public List<String> getBrandCodes() {
        return brandCodes;
    }

    public void setBrandCodes(List<String> brandCodes) {
        this.brandCodes = brandCodes;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }
}
