/**
 * @(#) PlatformOrderVO.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.tcbj.api.dto.response.es.AddressVO;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.Date;

/**
 * ClaimOrderDetailRespDto
 */
@Data
@ApiModel(value = "ClaimOrderDetailRespDto", description = "")
public class ClaimOrderDetailRespDto {

    @ApiModelProperty(name = "id", value = "id")
    @JsonProperty("id")
    private String id;

    @ApiModelProperty(name = "platformOrderNo", value = "平台订单号")
    @JsonProperty("platformOrderNo")
    private String platformOrderNo;

    @ApiModelProperty(name = "claimLogisticsNo", value = "索赔物流单号")
    @JsonProperty("claimLogisticsNo")
    private String claimLogisticsNo;

    @ApiModelProperty(name = "consignmentNo", value = "托运单号")
    @JsonProperty("consignmentNo")
    private String consignmentNo;

    @ApiModelProperty(name = "sapOrderNo", value = "SAP销售订单号")
    @JsonProperty("sapOrderNo")
    private String sapOrderNo;

    @ApiModelProperty(name = "saleOrderNo", value = "内部销售单号")
    @JsonProperty("saleOrderNo")
    private String saleOrderNo;

    @ApiModelProperty(name = "sapOutOrderNo", value = "SAP销售交货号")
    @JsonProperty("sapOutOrderNo")
    private String sapOutOrderNo;

    @ApiModelProperty(name = "orderType", value = "订单类型，'claim_reissue': ''仓库索赔补发'','claim_posting': ''仓库索赔过账'','compensation_not_order': ''索赔不补发''," +
            " 'compensation_order': ''索赔补发'','bb_transfer_claim_not_reissue': ''BB调拨索赔不补发'','ds_transfer_claims_not_reissue': ''电商调拨索赔不补发'")
    @JsonProperty("orderType")
    private String orderType;

    @ApiModelProperty(name = "transferOrderStatus", value = "转单状态 -1-待上游审核 0-正常 1-异常 2-作废 3-已合并 4-待物流初审 5-待仓库复审 6-已审核")
    @JsonProperty("transferOrderStatus")
    private String transferOrderStatus;

    @ApiModelProperty(name = "customerCode", value = "客户编码")
    @JsonProperty("customerCode")
    private String customerCode;

    @ApiModelProperty(name = "customerName", value = "客户名称")
    @JsonProperty("customerName")
    private String customerName;

    @ApiModelProperty(name = "oldLongCode", value = "旧产品编码")
    @JsonProperty("oldLongCode")
    private String oldLongCode;

    @ApiModelProperty(name = "skuCode", value = "产品编码")
    @JsonProperty("skuCode")
    private String skuCode;

    @ApiModelProperty(name = "itemName", value = "产品名称")
    @JsonProperty("itemName")
    private String itemName;

    @ApiModelProperty(name = "unitId", value = "单位")
    @JsonProperty("unitId")
    private String unitId;

    @ApiModelProperty(name = "itemNum", value = "数量")
    @JsonProperty("itemNum")
    private Integer itemNum;

    @Valid
    @ApiModelProperty(name = "orderTotalAmount", value = "订单应收金额")
    @JsonProperty("orderTotalAmount")
    private BigDecimal orderTotalAmount;

    @ApiModelProperty(name = "claimLogisticsReason", value = "索赔原因")
    @JsonProperty("claimLogisticsReason")
    private String claimLogisticsReason;

    @ApiModelProperty(name = "channelWarehouseName", value = "渠道仓")
    private String channelWarehouseName;

    @ApiModelProperty(name = "orderChannelCode", value = "订单渠道编码")
    private String orderChannelCode;

    @ApiModelProperty(name = "distributionChannel", value = "分销渠道")
    private String distributionChannel;

    @ApiModelProperty(name = "sellerRemark", value = "商家备注")
    @JsonProperty("sellerRemark")
    private String sellerRemark;

    @ApiModelProperty(name = "transferOrderTime", value = "转单时间")
    @JsonProperty("transferOrderTime")
    private Date transferOrderTime;

    @ApiModelProperty(name = "platformCreateTime", value = "平台下单时间")
    @JsonProperty("platformCreateTime")
    private Date platformCreateTime;

    @ApiModelProperty(name = "createTime", value = "渠道订单创建时间")
    @JsonProperty("createTime")
    private Date createTime;

    @ApiModelProperty(name = "orderStatusCn", value = "发货状态")
    @JsonProperty("orderStatusCn")
    private String orderStatusCn;

    /**
     *  组织code
     */
    @JsonProperty("organizationCode")
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;
    /**
     *  组织名称
     */
    @JsonProperty("organizationName")
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    @JsonProperty("receiveName")
    @ApiModelProperty(name = "receiveName", value = "收货人")
    private String receiveName;

    @JsonProperty("receivePhone")
    @ApiModelProperty(name = "receivePhone", value = "收货手机")
    private String receivePhone;

    @JsonProperty("province")
    @ApiModelProperty(name = "province", value = "省")
    private String province;

    @JsonProperty("city")
    @ApiModelProperty(name = "city", value = "市")
    private String city;

    @JsonProperty("county")
    @ApiModelProperty(name = "county", value = "区")
    private String county;

    @JsonProperty("receiveAddress")
    @ApiModelProperty(name = "receiveAddress", value = "收货地址")
    private String receiveAddress;

    @JsonProperty("replacementFlag")
    @ApiModelProperty(name = "replacementFlag", value = "明细类型")
    private String replacementFlag;

    @JsonProperty("isGift")
    @ApiModelProperty(name = "isGift", value = "是否礼品")
    private String isGift;

    @JsonProperty("auditPerson")
    @ApiModelProperty(name = "auditPerson", value = "审核人")
    private String auditPerson;

    @JsonProperty("auditTime")
    @ApiModelProperty(name = "auditTime", value = "仓库审核通过时间")
    private String auditTime;

}

