package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>Tile </p>
 *
 * <p>description</p>
 *
 * @author 天泽
 * @date
 * @since 0.1.0
 */
@Data
@ApiModel(value = "LogisticOutResultInfoRespDto", description = "物流在途返回dto")
public class LogisticOutResultInfoRespDto implements Serializable {
    /**
     *  出货结果单id
     */
    @ApiModelProperty(name = "outResultOrderId",value = "出货结果单id")
    private Long outResultOrderId;

    /**
     *  物流信息表id
     */
    @ApiModelProperty(name = "logisticsInfoId",value = "物流信息表id")
    private Long logisticsInfoId;


    /**
     *  托运单号
     */
    @ApiModelProperty(name = "consignmentNo",value = "托运单号")
    private String consignmentNo;


    /**
     *  通知单号
     */
    @ApiModelProperty(name = "preOrderNo",value = "通知单号")
    private String preOrderNo;

    /**
     *  关联单号
     */
    @ApiModelProperty(name = "relevanceNo",value = "关联单号")
    private String relevanceNo;

    /**
     *  业务类型
     */
    @ApiModelProperty(name = "businessType",value = "业务类型")
    private String businessType;


    /**
     *  预计到货时间
     */
    @ApiModelProperty(name = "estimatedTime",value = "预计到货时间")
    private Date estimatedTime;

    /**
     *  实际到达时间
     */
    @ApiModelProperty(name = "actualArrivalTime",value = "实际到达时间")
    private Date actualArrivalTime;

    /**
     *  状态0:提交，1：捡货，2：发货，3：在途，4.签收
     */
    @ApiModelProperty(name = "status",value = "状态0:提交，1：捡货，2：发货，3：在途，4.签收")
    private String status;


    /**
     *  外部单号
     */
    @ApiModelProperty(name = "externalOrderNo",value = "外部单号")
    private String externalOrderNo;

    /**
     *  物流公司编码
     */
    @ApiModelProperty(name = "shippingCompanyCode",value = "物流公司编码")
    private String shippingCompanyCode;

    /**
     *  物流公司
     */
    @ApiModelProperty(name = "shippingCompany",value = "物流公司")
    private String shippingCompany;

    /**
     *  物流商类型 1-物流 2-快递
     */
    @ApiModelProperty(name = "shipmentEnterpriseType",value = "物流商类型 1-物流 2-快递")
    private Integer shipmentEnterpriseType;







}
