package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.CsOutNoticeOrderDetailReqDto;
import com.dtyunxi.tcbj.api.dto.response.CsOutNoticeOrderDetailRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 出/入库通知单明细服务接口
*
* @author 天泽
* @since 2022-08-30
*/
@Api(tags = {"出/入库通知单明细服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-ICsOutNoticeOrderDetailApi",
    name = "${tcbj.center.report.name:tcbj-center-report}",
    path = "/csOutNoticeOrderDetail",
    url = "${tcbj.center.report.api:}"
)
public interface ICsOutNoticeOrderDetailApi {

/**
* 新增出/入库通知单明细
*
* @param addReqDto 出/入库通知单明细请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增出/入库通知单明细", notes = "新增出/入库通知单明细")
RestResponse<Long> addCsOutNoticeOrderDetail(@RequestBody CsOutNoticeOrderDetailReqDto addReqDto);

    /**
    * 修改出/入库通知单明细
    *
    * @param modifyReqDto 出/入库通知单明细请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改出/入库通知单明细", notes = "修改出/入库通知单明细")
    RestResponse<Void> modifyCsOutNoticeOrderDetail(@RequestBody CsOutNoticeOrderDetailReqDto modifyReqDto);

    /**
    * 删除出/入库通知单明细
    *
    * @param ids        出/入库通知单明细删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除出/入库通知单明细", notes = "删除出/入库通知单明细")
    RestResponse<Void> removeCsOutNoticeOrderDetail(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
