package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
* 成品库存报表Eo对象
*
* @author 紫霄
* @since 2022-12-08
*/
@ApiModel(value = "FinishedInventoryReqDto", description = "成品库存报表Eo对象")
public class FinishedInventoryReqDto extends BasePageDto {
    /**
    *  
    */
    @ApiModelProperty(name = "id", value = "")
    private Long id;

    /**
     *  仓库id
     */
    @ApiModelProperty(name = "warehouseId", value = "仓库id")
    private Long warehouseId;

    /**
    *  统计时间
    */
    @ApiModelProperty(name = "statisticalTime", value = "统计时间")
    private Date statisticalTime;

    @ApiModelProperty(name = "statisticalTimeStart", value = "统计时间开始")
    private Date statisticalTimeStart;

    @ApiModelProperty(name = "statisticalTimeEnd", value = "统计时间结束")
    private Date statisticalTimeEnd;


    /**
     *  组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
    *  货品名称
    */
    @ApiModelProperty(name = "cargoName", value = "货品名称")
    private String cargoName;
    /**
    *  库存总量(万)
    */
    @ApiModelProperty(name = "totalBalance", value = "库存总量(万)")
    private BigDecimal totalBalance;
    /**
    *  在库最新批次
    */
    @ApiModelProperty(name = "newestBatch", value = "在库最新批次")
    private String newestBatch;
    /**
    *  在库最旧批次
    */
    @ApiModelProperty(name = "oldestBatch", value = "在库最旧批次")
    private String oldestBatch;
    /**
    *  药业线上库存总量(万)
    */
    @ApiModelProperty(name = "yyxsBalance", value = "药业线上库存总量(万)")
    private BigDecimal yyxsBalance;
    /**
    *  药业库存总量(万)
    */
    @ApiModelProperty(name = "yyBalance", value = "药业库存总量(万)")
    private BigDecimal yyBalance;
    /**
    *  佰傲库存总量(万)
    */
    @ApiModelProperty(name = "baBalance", value = "佰傲库存总量(万)")
    private BigDecimal baBalance;
    /**
    *  食代说库存总量(万)
    */
    @ApiModelProperty(name = "sdsBalance", value = "食代说库存总量(万)")
    private BigDecimal sdsBalance;
    /**
    *  佰腾库存总量(万)
    */
    @ApiModelProperty(name = "btBalance", value = "佰腾库存总量(万)")
    private BigDecimal btBalance;
    /**
     *  珠海佰腾库存总量(万)
     */
    @ApiModelProperty(name = "zhbtBalance", value = "珠海佰腾库存总量(万)")
    private BigDecimal zhbtBalance;
    /**
    *  佰嘉库存总量(万)
    */
    @ApiModelProperty(name = "bjBalance", value = "佰嘉库存总量(万)")
    private BigDecimal bjBalance;
    /**
    *  股份库存总量(万)
    */
    @ApiModelProperty(name = "gfBalance", value = "股份库存总量(万)")
    private BigDecimal gfBalance;

    /**
     *  广州麦优库存总量(万)
     */
    @ApiModelProperty(name = "gzmyBalance", value = "广州麦优库存总量(万)")
    private BigDecimal gzmyBalance;
    /**
     *  珠海麦优库存总量(万)
     */
    @ApiModelProperty(name = "zhmyBalance", value = "珠海麦优库存总量(万)")
    private BigDecimal zhmyBalance;
    /**
    *  超三个月总量(万)
    */
    @ApiModelProperty(name = "overThreeBalance", value = "超三个月总量(万)")
    private BigDecimal overThreeBalance;
    /**
    *  小于三个月总量(万)
    */
    @ApiModelProperty(name = "inThreeBalance", value = "小于三个月总量(万)")
    private BigDecimal inThreeBalance;
    /**
    *  超三个月比例
    */
    @ApiModelProperty(name = "overThreeRatio", value = "超三个月比例")
    private BigDecimal overThreeRatio;
    /**
    *  超九个月库存总量(万)
    */
    @ApiModelProperty(name = "overNineBalance", value = "超九个月库存总量(万)")
    private BigDecimal overNineBalance;
    /**
    *  超九个月比例
    */
    @ApiModelProperty(name = "overNineRatio", value = "超九个月比例")
    private BigDecimal overNineRatio;
    /**
    *  小于九个月库存总量(万)
    */
    @ApiModelProperty(name = "inNineBalance", value = "小于九个月库存总量(万)")
    private BigDecimal inNineBalance;
    /**
    *  小于九个月比例
    */
    @ApiModelProperty(name = "inNineRatio", value = "小于九个月比例")
    private BigDecimal inNineRatio;

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }

    public void setWarehouseId(Long warehouseId){
        this.warehouseId = warehouseId;
    }
    public Long getWarehouseId(){
        return this.warehouseId;
    }

    public void setOrganizationName(String organizationName){
        this.organizationName = organizationName;
    }
    public String getOrganizationName(){
        return this.organizationName;
    }

    public void setStatisticalTimeStart(Date statisticalTimeStart){
    this.statisticalTimeStart = statisticalTimeStart;
    }
    public Date getStatisticalTimeStart(){
    return this.statisticalTimeStart;
    }

    public void setStatisticalTime(Date statisticalTime){
        this.statisticalTime = statisticalTime;
    }
    public Date getStatisticalTime(){
        return this.statisticalTime;
    }

    public void setStatisticalTimeEnd(Date statisticalTimeEnd){
        this.statisticalTimeEnd = statisticalTimeEnd;
    }
    public Date getStatisticalTimeEnd(){
        return this.statisticalTimeEnd;
    }

    public void setLongCode(String longCode){
    this.longCode = longCode;
    }
    public String getLongCode(){
    return this.longCode;
    }
    public void setCargoName(String cargoName){
    this.cargoName = cargoName;
    }
    public String getCargoName(){
    return this.cargoName;
    }
    public void setTotalBalance(BigDecimal totalBalance){
    this.totalBalance = totalBalance;
    }
    public BigDecimal getTotalBalance(){
    return this.totalBalance;
    }
    public void setNewestBatch(String newestBatch){
    this.newestBatch = newestBatch;
    }
    public String getNewestBatch(){
    return this.newestBatch;
    }
    public void setOldestBatch(String oldestBatch){
    this.oldestBatch = oldestBatch;
    }
    public String getOldestBatch(){
    return this.oldestBatch;
    }
    public void setYyxsBalance(BigDecimal yyxsBalance){
    this.yyxsBalance = yyxsBalance;
    }
    public BigDecimal getYyxsBalance(){
    return this.yyxsBalance;
    }
    public void setYyBalance(BigDecimal yyBalance){
    this.yyBalance = yyBalance;
    }
    public BigDecimal getYyBalance(){
    return this.yyBalance;
    }
    public void setBaBalance(BigDecimal baBalance){
    this.baBalance = baBalance;
    }
    public BigDecimal getBaBalance(){
    return this.baBalance;
    }
    public void setSdsBalance(BigDecimal sdsBalance){
    this.sdsBalance = sdsBalance;
    }
    public BigDecimal getSdsBalance(){
    return this.sdsBalance;
    }
    public void setBtBalance(BigDecimal btBalance){
    this.btBalance = btBalance;
    }
    public BigDecimal getBtBalance(){
    return this.btBalance;
    }
    public void setBjBalance(BigDecimal bjBalance){
    this.bjBalance = bjBalance;
    }
    public BigDecimal getBjBalance(){
    return this.bjBalance;
    }
    public void setGfBalance(BigDecimal gfBalance){
    this.gfBalance = gfBalance;
    }
    public BigDecimal getGfBalance(){
    return this.gfBalance;
    }
    public void setOverThreeBalance(BigDecimal overThreeBalance){
    this.overThreeBalance = overThreeBalance;
    }
    public BigDecimal getOverThreeBalance(){
    return this.overThreeBalance;
    }
    public void setInThreeBalance(BigDecimal inThreeBalance){
    this.inThreeBalance = inThreeBalance;
    }
    public BigDecimal getInThreeBalance(){
    return this.inThreeBalance;
    }
    public void setOverThreeRatio(BigDecimal overThreeRatio){
    this.overThreeRatio = overThreeRatio;
    }
    public BigDecimal getOverThreeRatio(){
    return this.overThreeRatio;
    }
    public void setOverNineBalance(BigDecimal overNineBalance){
    this.overNineBalance = overNineBalance;
    }
    public BigDecimal getOverNineBalance(){
    return this.overNineBalance;
    }
    public void setOverNineRatio(BigDecimal overNineRatio){
    this.overNineRatio = overNineRatio;
    }
    public BigDecimal getOverNineRatio(){
    return this.overNineRatio;
    }
    public void setInNineBalance(BigDecimal inNineBalance){
    this.inNineBalance = inNineBalance;
    }
    public BigDecimal getInNineBalance(){
    return this.inNineBalance;
    }
    public void setInNineRatio(BigDecimal inNineRatio){
    this.inNineRatio = inNineRatio;
    }
    public BigDecimal getInNineRatio(){
    return this.inNineRatio;
    }

    public BigDecimal getGzmyBalance() {
        return gzmyBalance;
    }

    public void setGzmyBalance(BigDecimal gzmyBalance) {
        this.gzmyBalance = gzmyBalance;
    }

    public BigDecimal getZhmyBalance() {
        return zhmyBalance;
    }

    public void setZhmyBalance(BigDecimal zhmyBalance) {
        this.zhmyBalance = zhmyBalance;
    }

    public BigDecimal getZhbtBalance() {
        return zhbtBalance;
    }

    public void setZhbtBalance(BigDecimal zhbtBalance) {
        this.zhbtBalance = zhbtBalance;
    }
}
