package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
* 计划放行Eo对象
*
* @author 紫霄
* @since 2023-05-10
*/
@ApiModel(value = "InspectionReleasePlanReqDto", description = "计划放行Eo对象")
@Data
public class InspectionReleasePlanReqDto extends RequestDto{
    /**
    *  主键id
    */
    @ApiModelProperty(name = "id", value = "主键id")
    private Long id;
    /**
    *  SKU code
    */
    @ApiModelProperty(name = "skuCode", value = "SKU code")
    private String skuCode;

    @ApiModelProperty(name = "skuCodeList", value = "SKU code")
    private List<String> skuCodeList;
    /**
    *  SKU 名称
    */
    @ApiModelProperty(name = "skuName", value = "SKU 名称")
    private String skuName;
    /**
    *  批次
    */
    @ApiModelProperty(name = "batch", value = "批次")
    private String batch;

    @ApiModelProperty(name = "batchList", value = "批次")
    private List<String> batchList;
    /**
    *  计划放行数量
    */
    @ApiModelProperty(name = "planReleaseNum", value = "计划放行数量")
    private BigDecimal planReleaseNum;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;




}
