package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderApportionReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(tags = {"分摊单据服务"})
@FeignClient(
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/saleOrderApportion",
        url = "${tcbj.center.report.api:}"
)
public interface ISaleOrderApportionApi {


    @PostMapping("/refreshOpenPullDate")
    @ApiOperation(value = "刷新允许拉单时间", notes = "刷新允许拉单时间")
    RestResponse<Void> refreshOpenPullDate(@RequestBody SaleOrderApportionReqDto reqDto);
}
