package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * SAP拉单限流配置请求DTO
 *
 * @author system
 * @date 2024-11-15
 */
@ApiModel(value = "SapPullRateLimitConfigReqDto", description = "SAP拉单限流配置请求对象")
public class SapPullRateLimitConfigReqDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("是否启用限流控制")
    private Boolean enabled;

    @ApiModelProperty("每小时最大可拉单量")
    private Integer maxOrdersPerHour;

    @ApiModelProperty("是否启用Extension字段过滤")
    private Boolean enableExtensionFilter;

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getMaxOrdersPerHour() {
        return maxOrdersPerHour;
    }

    public void setMaxOrdersPerHour(Integer maxOrdersPerHour) {
        this.maxOrdersPerHour = maxOrdersPerHour;
    }

    public Boolean getEnableExtensionFilter() {
        return enableExtensionFilter;
    }

    public void setEnableExtensionFilter(Boolean enableExtensionFilter) {
        this.enableExtensionFilter = enableExtensionFilter;
    }

    @Override
    public String toString() {
        return "SapPullRateLimitConfigReqDto{" +
                "enabled=" + enabled +
                ", maxOrdersPerHour=" + maxOrdersPerHour +
                ", enableExtensionFilter=" + enableExtensionFilter +
                '}';
    }
}

