package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.EmployeeOrgQueryReqDto;
import com.dtyunxi.tcbj.api.dto.request.OrgSellerCustomerQueryReqDto;
import com.dtyunxi.tcbj.api.dto.response.EmployeeOrgRespDto;
import com.dtyunxi.tcbj.api.dto.response.OrgSellerCustomerRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @Author: xiuji
 * @Date: 2022/2/18 11:04 AM
 */
@Api(tags = {"报表中心：组织商家客户查询"})
@FeignClient(
        name = "${com.dtyunxi.tcbj.api.name:tcbj-center-report}",
        path = "/v1/orgSeller",
        url = "${tcbj.center.report.api:}"
)
public interface IOrgSellerCustomerQueryApi {

    /**
     * 查询组织商家客户分页
     *
     * @param queryReqDto 查询参数
     */
    @PostMapping(value = {"/orgSellerCustomerPage"}, produces = "application/json")
    @ApiOperation(value = "查询组织商家客户分页", notes = "查询组织商家客户分页")
    RestResponse<PageInfo<OrgSellerCustomerRespDto>> orgSellerCustomerPage(@RequestBody OrgSellerCustomerQueryReqDto queryReqDto);

    /**
     * 组织人员分页接口
     * @param queryReqDto
     * @return
     */
    @PostMapping(value = {"/queryEmployeeOrgPage"}, produces = "application/json")
    @ApiOperation(value = "组织人员分页接口", notes = "组织人员分页接口")
    RestResponse<PageInfo<EmployeeOrgRespDto>> queryEmployeeOrgPage(@RequestBody EmployeeOrgQueryReqDto queryReqDto);

    @PostMapping(value = {"/employeeByCustomerIdPage"}, produces = "application/json")
    @ApiOperation(value = "根据客户id查询人员分页信息", notes = "根据客户id查询人员分页信息")
    RestResponse<PageInfo<EmployeeOrgRespDto>> employeeByCustomerIdPage(@RequestBody EmployeeOrgQueryReqDto queryReqDto);
}
