package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SalesOrderStatisticsQueryDto;
import com.dtyunxi.tcbj.api.dto.request.SalesOrderStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.response.SalesOrderStatisticsExtDto;
import com.dtyunxi.tcbj.api.dto.response.SalesOrderStatisticsRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 销售订单下单统计服务接口
*
* @author 天泽
* @since 2022-08-24
*/
@Api(tags = {"销售订单下单统计服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-ISalesOrderStatisticsQueryApi",
    name = "${tcbj.center.report.name:tcbj-center-report}",
    path = "/v1/salesOrderStatistics",
    url = "${tcbj.center.report.api:}"
)
public interface ISalesOrderStatisticsQueryApi {

    /**
    * 根据id查询销售订单下单统计
    *
    * @param id 销售订单下单统计id
    * @return   销售订单下单统计数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询销售订单下单统计", notes = "根据id查询销售订单下单统计")
    RestResponse<SalesOrderStatisticsRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 销售订单下单统计分页数据
    *
    * @param filter   销售订单下单统计查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 销售订单下单统计分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "销售订单下单统计分页数据", notes = "根据filter查询条件查询销售订单下单统计数据，filter=SalesOrderStatisticsReqDto")
    RestResponse<PageInfo<SalesOrderStatisticsRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                    @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                    @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 销售订单下单统计
     * @param queryDto
     * @return
     */
    @PostMapping("/salesOrderPlaceOrder")
    @ApiOperation(value = "销售订单下单统计", notes = "销售订单下单统计，SalesOrderStatisticsQueryDto")
    RestResponse<SalesOrderStatisticsExtDto> salesOrderPlaceOrder(@RequestBody SalesOrderStatisticsQueryDto queryDto);


}
