package com.dtyunxi.tcbj.api.dto.response;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
* 分拣费用报表Eo对象
*
* @author fengjian
* @since 2022-07-18
*/
@ApiModel(value = "SortingExpenseRespDto", description = "分拣费用报表Eo对象")
@Data
public class SortingExpenseRespDto extends BaseRespDto{
    /**
    *  id
    */
    @ApiModelProperty(name = "id", value = "")
    private Long id;
    /**
    *  出库时间
    */
    @ApiModelProperty(name = "outWarehouseTime", value = "出库时间")
    private Date outWarehouseTime;
    /**
    *  WMS出库单号
    */
    @ApiModelProperty(name = "wmsOrderNo", value = "WMS出库单号")
    private String wmsOrderNo;
    /**
    *  出库结果单号
    */
    @ApiModelProperty(name = "documentNo", value = "出库结果单号")
    private String documentNo;
    /**
     *  托运单号
     */
    @ApiModelProperty(name = "consignmentNo", value = "托运单号")
    private String consignmentNo;

    /**
     * 业务类型
     */
    private String businessType;

    /**
    *  出库仓编码
    */
    @ApiModelProperty(name = "outLogicWarehouseCode", value = "出库仓编码")
    private String outLogicWarehouseCode;
    /**
    *  出库仓名称
    */
    @ApiModelProperty(name = "outLogicWarehouseName", value = "出库仓名称")
    private String outLogicWarehouseName;
    /**
    *  调出库存组织id
    */
    @ApiModelProperty(name = "outOrganizationId", value = "调出库存组织id")
    private String outOrganizationId;
    /**
    *  调出库存组织
    */
    @ApiModelProperty(name = "outOrganizationName", value = "调出库存组织")
    private String outOrganizationName;
    /**
    *  入库仓编码
    */
    @ApiModelProperty(name = "inLogicWarehouseCode", value = "入库仓编码")
    private String inLogicWarehouseCode;
    /**
    *  入库仓名称
    */
    @ApiModelProperty(name = "inLogicWarehouseName", value = "入库仓名称")
    private String inLogicWarehouseName;
    /**
    *  调入库存组织id
    */
    @ApiModelProperty(name = "inOrganizationId", value = "调入库存组织id")
    private String inOrganizationId;
    /**
    *  调入库存组织
    */
    @ApiModelProperty(name = "inOrganizationName", value = "调入库存组织")
    private String inOrganizationName;
    /**
    *  费用归属组织id
    */
    @ApiModelProperty(name = "expenseOrganizationId", value = "费用归属组织id")
    private String expenseOrganizationId;
    /**
    *  费用归属组织
    */
    @ApiModelProperty(name = "expenseOrganizationName", value = "费用归属组织")
    private String expenseOrganizationName;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
    *  商品名称
    */
    @ApiModelProperty(name = "cargoName", value = "商品名称")
    private String cargoName;
    /**
    *  出库数量
    */
    @ApiModelProperty(name = "doneQuantity", value = "出库数量")
    private BigDecimal doneQuantity;
    /**
    *  装箱数
    */
    @ApiModelProperty(name = "bigRatio", value = "装箱数")
    private Long bigRatio;
    /**
    *  小箱瓶数
    */
    @ApiModelProperty(name = "smallRatio", value = "小箱瓶数")
    private Long smallRatio;
    /**
    *  大箱数量
    */
    @ApiModelProperty(name = "bigBoxNum", value = "大箱数量")
    private BigDecimal bigBoxNum;
    /**
    *  小箱数量
    */
    @ApiModelProperty(name = "smallBoxNum", value = "小箱数量")
    private BigDecimal smallBoxNum;
    /**
    *  个数
    */
    @ApiModelProperty(name = "boxNum", value = "个数")
    private BigDecimal boxNum;
    /**
    *  调整类型；1：增加；2：减少
    */
    @ApiModelProperty(name = "adjustType", value = "调整类型；1：增加；2：减少")
    private Long adjustType;
    /**
    *  调整金额
    */
    @ApiModelProperty(name = "adjustNum", value = "调整金额")
    private BigDecimal adjustNum;
    /**
    *  调整备注
    */
    @ApiModelProperty(name = "adjustRemarks", value = "调整备注")
    private String adjustRemarks;
    /**
    *  分拣费
    */
    @ApiModelProperty(name = "sortingNum", value = "分拣费")
    private BigDecimal sortingNum;
    /**
    *  最后修改人
    */
    @ApiModelProperty(name = "importUpdatePerson", value = "最后修改人")
    private String importUpdatePerson;
    /**
    *  最后修改时间
    */
    @ApiModelProperty(name = "importUpdateTime", value = "最后修改时间")
    private Date importUpdateTime;

    @ApiModelProperty(name = "outDocumentNo", value = "出库通知单号")
    private String outDocumentNo;

    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "出库物理仓")
    private String outPhysicsWarehouseName;

    private Integer abnormal;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;
    /**
     * 目的省
     */
    @ApiModelProperty(name = "endProvince", value = "目的省")
    private String endProvince;
    /**
     * 目的省编码
     */
    @ApiModelProperty(name = "endProvinceCode", value = "目的省编码")
    private String endProvinceCode;
    /**
     * 目的市
     */
    @ApiModelProperty(name = "endCity", value = "目的市")
    private String endCity;
    /**
     * 目的市编码
     */
    @ApiModelProperty(name = "endCityCode", value = "目的市编码")
    private String endCityCode;
    /**
     * EAS单号
     */
    @ApiModelProperty(name = "easOrderNo", value = "EAS单号")
    private String easOrderNo;
    /**
     * 异常原因
     *
     */
    private String abnormalCauses;

    private String relevanceNo;

    private String externalOrderNo;
    
    @ApiModelProperty(name = "wmsMergeDocumentNo", value = "wms合单号")
    private String wmsMergeDocumentNo;

    @ApiModelProperty(name = "joinMergeDocumentNo", value = "加入合单号")
    private String joinMergeDocumentNo;

    /**
     * 关联每日发货报表记录id
     */
    @ApiModelProperty(name = "linkDailyReportId", value = "关联每日发货报表id")
    private Long linkDailyReportId;
    /**
     * 不计费原因
     */
    @ApiModelProperty(name = "noBillingReason", value = "不计费原因")
    private String noBillingReason;
    /**
     * 是否计费,0不计费,1计费
     */
    @ApiModelProperty(name = "billingFeeFlag", value = "是否计费,0不计费,1计费")
    private Integer billingFeeFlag;
    /**
     * 是否归档,0未归档,1已归档
     */
    @ApiModelProperty(name = "placedFlag", value = "是否归档,0未归档,1已归档")
    private Integer placedFlag;

    @ApiModelProperty(name = "outNoticeNo", value = "出库通知单单号")
    private String outNoticeNo;

    public String getUniqueKey(){
        return  String.format("%s;%s", this.getDocumentNo(), this.getLongCode());
    }


}
