package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @Author: xiuji
 * @Date: 2022/2/15 2:46 PM
 */
@ApiModel(value = "OrgSellerCustomerQueryReqDto", description = "组织商家客户查询DTO")
public class OrgSellerCustomerQueryReqDto extends RequestDto {

    @ApiModelProperty(name = "merchantId", value = "当前登录所属组织Id")
    private Long merchantId;
    @ApiModelProperty(name = "merchantIdList", value = "当前登录所属组织Id集合")
    private List<Long> merchantIdList;
    @ApiModelProperty(name = "organizationId", value = "组织Id")
    private Long organizationId;
    @ApiModelProperty(name = "organizationIdList",value = "组织id集合")
    private List<Long> organizationIdList;
    @ApiModelProperty(name = "orgNameLike",value = "组织名称-模糊查询")
    private String orgNameLike;
    @ApiModelProperty(name = "orgCodeLike",value = "组织编码-模糊查询")
    private String orgCodeLike;
    @ApiModelProperty(name = "sellerNameLike",value = "商家名称-模糊查询")
    private String sellerNameLike;
    @ApiModelProperty(name = "superiorSellerName",value = "上级商家名称-模糊查询")
    private String superiorSellerNameLike;
    @ApiModelProperty(name = "dealerCode",value = "客户/经销商编号-模糊查询")
    private String dealerCodeLike;

    private int pageNum;

    private int pageSize;

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public List<Long> getMerchantIdList() {
        return merchantIdList;
    }

    public void setMerchantIdList(List<Long> merchantIdList) {
        this.merchantIdList = merchantIdList;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public List<Long> getOrganizationIdList() {
        return organizationIdList;
    }

    public void setOrganizationIdList(List<Long> organizationIdList) {
        this.organizationIdList = organizationIdList;
    }

    public String getOrgNameLike() {
        return orgNameLike;
    }

    public void setOrgNameLike(String orgNameLike) {
        this.orgNameLike = orgNameLike;
    }

    public String getOrgCodeLike() {
        return orgCodeLike;
    }

    public void setOrgCodeLike(String orgCodeLike) {
        this.orgCodeLike = orgCodeLike;
    }

    public String getSellerNameLike() {
        return sellerNameLike;
    }

    public void setSellerNameLike(String sellerNameLike) {
        this.sellerNameLike = sellerNameLike;
    }

    public String getSuperiorSellerNameLike() {
        return superiorSellerNameLike;
    }

    public void setSuperiorSellerNameLike(String superiorSellerNameLike) {
        this.superiorSellerNameLike = superiorSellerNameLike;
    }

    public String getDealerCodeLike() {
        return dealerCodeLike;
    }

    public void setDealerCodeLike(String dealerCodeLike) {
        this.dealerCodeLike = dealerCodeLike;
    }

    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}
