package com.dtyunxi.tcbj.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author minyue
 * @description: 授信账单汇总
 * @since 2022-01-12 17:00
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CreditStatementStatisticsReqDto", description = "授信账单汇总")
public class CreditStatementStatisticsReqDto extends ReportBrandBaseReqDto {

    @ApiModelProperty(name = "placeTimeStart", value = "时间起(年月)")
    private String placeTimeStart;

    @ApiModelProperty(name = "placeTimeEnd", value = "时间(年月)")
    private String placeTimeEnd;

    @ApiModelProperty(name = "accountingPeriodType", value = "账期类型: 1:已逾期 0：未逾期")
    private Integer accountingPeriodType;

    @ApiModelProperty(name = "accountingPeriodEndTime", value = "账期到期时间")
    private String accountingPeriodEndTime;

    /**
     * 客户id集合
     */
    private List<Long> customerIds;
}
