package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.SortingBillReportListPageReqDto;
import com.dtyunxi.tcbj.api.dto.request.SortingBillReportUpdateDto;
import com.dtyunxi.tcbj.api.dto.request.SortingCostReportListPageReqDto;
import com.dtyunxi.tcbj.api.dto.response.SortingBillCountDto;
import com.dtyunxi.tcbj.api.dto.response.SortingBillRespDto;
import com.dtyunxi.tcbj.api.dto.response.SortingCostReportRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 分拣账单报表服务接口
 * @author longling
 * @since 2024-11-13
 */
@Api(tags = {"分拣账单报表服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-query-ISortingExpenseQueryApi",
        name = "${tcbj.center.report.name:tcbj-center-report}",
        path = "/v1/sortingBill",
        url = "${tcbj.center.report.api:}"
)
public interface ISortingBillQueryApi {
    /**
     * 分拣账单报表分页数据
     *
     * @param sortingBillReportListPageReqDto   分拣账单报表查询条件、
     * @return 分拣账单报表分页数据
     */
    @PostMapping("/getSortingBillReportListPage")
    @ApiOperation(value = "分拣账单报表分页数据", notes = "分拣账单报表分页数据")
    RestResponse<PageInfo<SortingBillRespDto>> getSortingBillReportListPage(@RequestBody SortingBillReportListPageReqDto sortingBillReportListPageReqDto);

    /**
     * 分拣账单报表统计数据
     *
     * @param sortingBillReportListPageReqDto   分拣账单报表查询条件、
     * @return 分拣账单报表统计数据
     */
    @PostMapping("/getSortingBillReportListPageCount")
    @ApiOperation(value = "分拣账单报表统计数据", notes = "分拣账单报表统计数据")
    RestResponse<SortingBillCountDto> getSortingBillReportListPageCount(@RequestBody SortingBillReportListPageReqDto sortingBillReportListPageReqDto);

    /**
     * 分拣账单更新归档标识
     * @param updateReqDto
     * @return
     */
    @PostMapping("/updatePlaceStatus")
    @ApiOperation(value = "分拣账单更新归档标识", notes = "分拣账单更新归档标识")
    RestResponse<Integer> updatePlaceStatus(@RequestBody @Validated FeeReportPlaceUpdateReqDto updateReqDto);
}
