package com.dtyunxi.tcbj.api.dto.response;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class SaleTransferReportRespDto {

    @ApiModelProperty(name = "id", value = "销售单ID")
    private Long id;

    @ApiModelProperty(name = "saleOrderNo", value = "销售单单号")
    private String saleOrderNo;

    @ApiModelProperty(name = "orderType", value = "销售单据类型")
    private String orderType;

    @ApiModelProperty(name = "orderTypeStr", value = "销售单据类型Str")
    private String orderTypeStr;

    @ApiModelProperty(name = "platformOrderNo", value = "平台单号")
    private String platformOrderNo;

    @ApiModelProperty(name = "orderStatus", value = "单据状态")
    private String orderStatus;

    @ApiModelProperty(name = "orderStatusStr", value = "单据状态Str")
    private String orderStatusStr;

    @ApiModelProperty(name = "secondOrderStatus", value = "单据子状态")
    private String secondOrderStatus;

    @ApiModelProperty(name = "secondOrderStatusStr", value = "单据子状态Str")
    private String secondOrderStatusStr;

    @ApiModelProperty(name = "transferOrderNos", value = "调拨单单号")
    private String transferOrderNos;

    @ApiModelProperty(name = "transferType", value = "调拨类型")
    private String transferType;

    @ApiModelProperty(name = "transferOrderStatus", value = "调拨单状态")
    private String transferOrderStatus;

    @ApiModelProperty(name = "transferTypeStr", value = "调拨类型Str")
    private String transferTypeStr;

    @ApiModelProperty(name = "orderNeedQuantity", value = "订单明细所需")
    private BigDecimal orderNeedQuantity;

    @ApiModelProperty(name = "orderLackQuantity", value = "订单缺货")
    private BigDecimal orderLackQuantity;

    @ApiModelProperty(name = "transferQuantity", value = "调拨数量")
    private BigDecimal transferQuantity;

    @ApiModelProperty(name = "totalVolumeWeight", value = "订单明细总体积及总重量，'-' 隔开")
    private String totalVolumeWeight;

    @ApiModelProperty(name = "totalVolume", value = "订单明细总体积")
    private String totalVolume;

    @ApiModelProperty(name = "totalWeight", value = "订单明细总重量")
    private String totalWeight;

    @ApiModelProperty(name = "disposeStatus", value = "处理状态")
    private String disposeStatus;

    @ApiModelProperty(name = "disposeStatusStr", value = "处理状态Str")
    private String disposeStatusStr;

    @ApiModelProperty(name = "logicalWarehouseId", value = "指定发货仓ID")
    private String logicalWarehouseId;

    @ApiModelProperty(name = "logicalWarehouseCode", value = "指定发货仓编号")
    private String logicalWarehouseCode;

    @ApiModelProperty(name = "logicalWarehouseName", value = "指定发货仓名称")
    private String logicalWarehouseName;


    @ApiModelProperty(name = "sellerRemark", value = "商家备注")
    private String sellerRemark;

    @ApiModelProperty(name = "remark", value = "订单备注")
    private String remark;

    @ApiModelProperty(name = "tagNames", value = "手工标签")
    private String tagNames;

    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;

    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "province", value = "省")
    private String province;

    @ApiModelProperty(name = "provinceCode", value = "省编号")
    private String provinceCode;

    @ApiModelProperty(name = "city", value = "市")
    private String city;

    @ApiModelProperty(name = "cityCode", value = "市编号")
    private String cityCode;

    @ApiModelProperty(name = "county", value = "区")
    private String county;

    @ApiModelProperty(name = "countyCode", value = "区编号")
    private String countyCode;

    @ApiModelProperty(name = "receiveAddress", value = "客户地址")
    private String receiveAddress;

    @ApiModelProperty(name = "createTime", value = "订单内部创建时间")
    private Date createTime;

    @ApiModelProperty(name = "createTimeStr", value = "订单内部创建时间Str")
    private String createTimeStr;

    @ApiModelProperty(name = "channelWarehouseId", value = "渠道仓库ID")
    private String channelWarehouseId;

    @ApiModelProperty(name = "channelWarehouseName", value = "渠道仓库名称")
    private String channelWarehouseName;

    @ApiModelProperty(name = "channelWarehouseCode", value = "渠道仓库编号")
    private String channelWarehouseCode;

    @ApiModelProperty(name = "easOrderNo", value = "EAS单号")
    private String easOrderNo;

    @ApiModelProperty(name = "outPhysicsWarehouseCode", value = "销售调拨出库物理仓")
    private String outPhysicsWarehouseCode;

    @ApiModelProperty(name = "outPhysicsWarehouseName", value = "销售调拨出库物理仓名称")
    private String outPhysicsWarehouseName;

    @ApiModelProperty(name = "centerTransferOrderNo", value = "中转调拨单")
    private String centerTransferOrderNo;

    @ApiModelProperty(name = "centerTransferOrderStatus", value = "中转调拨单状态")
    private String centerTransferOrderStatus;

    /**
     * 调出逻辑仓编码
     */
    @ApiModelProperty(name = "outLogicWarehouseCode", value = "调出逻辑仓编码")
    private String outLogicWarehouseCode;
    /**
     * 调出逻辑仓名称
     */
    @ApiModelProperty(name = "outLogicWarehouseName", value = "调出逻辑仓名称")
    private String outLogicWarehouseName;
    /**
     * 调入逻辑仓编码
     */
    @ApiModelProperty(name = "inLogicWarehouseCode", value = "调入逻辑仓编码")
    private String inLogicWarehouseCode;
    /**
     * 调入逻辑仓名称
     */
    @ApiModelProperty(name = "inLogicWarehouseName", value = "调入逻辑仓名称")
    private String inLogicWarehouseName;

    @ApiModelProperty(name = "inOrganizationId", value = "调入组织id")
    private Long inOrganizationId;

    @ApiModelProperty(name = "inOrganization", value = "调入组织名称")
    private String inOrganization;

    @ApiModelProperty(name = "outOrganizationId", value = "调出组织id")
    private Long outOrganizationId;

    @ApiModelProperty(name = "outOrganization", value = "调出组织名称")
    private String outOrganization;

    @ApiModelProperty(name = "organizationCode", value = "组织编码")
    private String organizationCode;

    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    @ApiModelProperty(name = "inPhysicsWarehouseCode", value = "销售调拨单入库物理仓编码")
    private String inPhysicsWarehouseCode;

    @ApiModelProperty(name = "inPhysicsWarehouseName", value = "销售调拨单入库物理仓名称")
    private String inPhysicsWarehouseName;

    @ApiModelProperty(name = "centerTransferInPhysicsWarehouseCode", value = "中转调拨单入库物理仓编码")
    private String centerTransferInPhysicsWarehouseCode;

    @ApiModelProperty(name = "centerTransferInPhysicsWarehouseName", value = "中转调拨单入库物理仓名称")
    private String centerTransferInPhysicsWarehouseName;

}
