package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.*;
import com.dtyunxi.tcbj.api.dto.response.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.math.BigDecimal;
import java.util.List;

/**
 * 逻辑仓库存表服务接口
 *
 * @author wude
 * @since 2022-03-07
 */
@Api(tags = {"逻辑仓库存表服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/logicInventory", url = "${tcbj.center.report.api:}")
public interface ILogicInventoryQueryApi {

    /**
     * 根据id查询逻辑仓库存表
     *
     * @param id 逻辑仓库存表id
     * @return 逻辑仓库存表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询逻辑仓库存表", notes = "根据id查询逻辑仓库存表")
    RestResponse<LogicInventoryRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 逻辑仓库存表分页数据
     *
     * @param filter 逻辑仓库存表查询条件
     * @return 逻辑仓库存表分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "逻辑仓库存表分页数据", notes = "根据filter查询条件查询逻辑仓库存表数据，filter=LogicInventoryReqDto")
    RestResponse<PageInfo<LogicInventoryRespDto>> queryByPage(@RequestBody LogicInventoryReqDto filter);

    /**
     * 逻辑仓库存统计数据
     *
     * @param filter 逻辑仓库存表查询条件
     * @return 逻辑仓库存表分页数据
     */
    @PostMapping("/count")
    @ApiOperation(value = "逻辑仓库存统计数据", notes = "根据filter查询条件查询逻辑仓库存表数据，filter=LogicInventoryReqDto")
    RestResponse<LogicInventoryCountDto> queryByCount(@RequestBody LogicInventoryReqDto filter);

    /**
     * 逻辑仓库存统计数据
     *
     * @param cargoInventoryReqDtos 逻辑仓库存表查询条件
     * @return 逻辑仓库存表分页数据
     */
    @PostMapping("/queryInventory")
    @ApiOperation(value = "逻辑仓库存统计数据", notes = "根据filter查询条件查询逻辑仓库存表数据，filter=LogicInventoryReqDto")
    RestResponse<List<LogicInventoryRespDto>> queryInventoryByCargo(@RequestBody List<CargoInventoryReqDto> cargoInventoryReqDtos);


    /**
     * 逻辑仓总表库存表分页数据
     *
     * @param filter 逻辑仓库存表查询条件
     * @return 逻辑仓库存表分页数据
     */
    @PostMapping("/queryTotalByPage")
    @ApiOperation(value = "逻辑仓总表库存表分页数据", notes = "逻辑仓总表库存表分页数据，filter=LogicInventoryReqDto")
    RestResponse<PageInfo<LogicInventoryRespDto>> queryTotalByPage(@RequestBody LogicInventoryReqDto filter);

    /**
     * 逻辑仓库总表存统计数据
     *
     * @param filter 逻辑仓库存表查询条件
     * @return 逻辑仓库存表分页数据
     */
    @PostMapping("/queryTotalByCount")
    @ApiOperation(value = "逻辑仓库存统计数据", notes = "根据filter查询条件查询逻辑仓库存表数据，filter=LogicInventoryReqDto")
    RestResponse<LogicInventoryCountDto> queryTotalByCount(@RequestBody LogicInventoryReqDto filter);


    @PostMapping("/queryPhysicalByPage")
    @ApiOperation(value = "物理仓可用报表", notes = "根据filter查询条件查询逻辑仓库存表数据，filter=PhysicalInventoryReqDto")
    RestResponse<PageInfo<PhysicalInventoryRespDto>> queryPhysicalByPage(@RequestBody PhysicalInventoryReqDto filter);

    @PostMapping("/queryPhysicalByCount")
    @ApiOperation(value = "物理仓可用报表统计数据", notes = "根据filter查询条件查询逻辑仓库存表数据，filter=LogicInventoryReqDto")
    RestResponse<PhysicalInventoryCountDto> queryPhysicalByCount(@RequestBody(required =false) PhysicalInventoryReqDto filter);

    @PostMapping("/queryLogicInventoryByCount")
    @ApiOperation(value = "逻辑仓库存统计", notes = "根据filter查询条件查询逻辑仓库存表数据，filter=LogicInventoryReqDto")
    RestResponse<LogicalInventoryCountPageVO> queryLogicInventoryByCount(@RequestBody(required =false) LogicalInventoryListPageParams filter);

    @GetMapping("/{itemLongCode}/{physicsWarehouseCode}")
    @ApiOperation(value = "根据商品长编码和物理仓编码查询在途库存", notes = "根据商品长编码和物理仓编码查询在途库存")
    RestResponse<BigDecimal> queryByIntransit(@PathVariable("itemLongCode") String itemLongCode, @PathVariable("physicsWarehouseCode") String physicsWarehouseCode);


    @PostMapping("/queryLogicInventoryList")
    @ApiOperation(value = "货品逻辑库存查询快照实时", notes = "根据filter查询条件查询逻辑仓库存表数据，filter=LogicInventoryReqDto")
    RestResponse<List<LogicInventoryListRespDto>> queryLogicInventoryList(@RequestBody LogicInventoryListReqDto filter);

    @PostMapping("/queryInventoryByParamList")
    @ApiOperation(value = "计划中心库存查询", notes = "计划中心库存查询")
    RestResponse<List<SkuInventoryRespDto>> queryInventoryByParamList(@RequestBody List<SkuInventoryReqDto> skuInventoryReqDtos);

    @PostMapping("/queryLogicInventoryListByBatch")
    @ApiOperation(value = "库存生产日期分组查询", notes = "库存生产日期分组查询")
    RestResponse<List<SkuInventoryBatchRespDto>> queryLogicInventoryListByBatch(@RequestBody SkuInventoryBatchReqDto skuInventoryBatchReqDto);

    @PostMapping("/queryInspectionReleaseInventory")
    @ApiOperation(value = "查询待检转合格列表", notes = "查询待检转合格列表")
    RestResponse<PageInfo<InspectionReleaseLogicInventoryRespDto>> queryInspectionReleaseInventory(@RequestBody InspectionReleaseLogicInventoryReqDto reqDto);

    @PostMapping("/queryInspectionReleaseInventoryCount")
    @ApiOperation(value = "查询待检转合格列表数量", notes = "查询待检转合格列表数量")
    RestResponse<InspectionReleaseLogicInventoryCountRespDto> queryInspectionReleaseInventoryCount(@RequestBody InspectionReleaseLogicInventoryReqDto reqDto);

    @PostMapping("/queryList")
    @ApiOperation(value = "查询逻辑仓库存信息", notes = "查询逻辑仓库存信息")
    RestResponse<List<LogicInventoryRespDto>> queryList(@RequestBody LogicInventoryListReqDto reqDto);

}
