/**
 * @(#) BusinessOrderInfoVO.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response.es;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 业务单信息
 */
@Data
@ApiModel(value = "BusinessOrderInfoVO", description = "业务单信息")
public class BusinessOrderInfoVO {
  
  @ApiModelProperty(name="address", value = "收货地址")
  @JsonProperty("address")
  private String address = null;
  
  
  @ApiModelProperty(name="planTime", value = "计划发货时间")
  @JsonProperty("planTime")
  private String planTime = null;
  
  
  @ApiModelProperty(name="businessOrderNo", value = "业务单号")
  @JsonProperty("businessOrderNo")
  private String businessOrderNo;
  
  
  @ApiModelProperty(name="businessOrderType", value = "业务类型")
  @JsonProperty("businessOrderType")
  private String businessOrderType = null;
  
  
  @ApiModelProperty(name="reciveName", value = "收货人")
  @JsonProperty("reciveName")
  private String reciveName = null;
  
  
  @ApiModelProperty(name="recivePhone", value = "手机")
  @JsonProperty("recivePhone")
  private String recivePhone = null;
  
  
  @ApiModelProperty(name="remark", value = "备注")
  @JsonProperty("remark")
  private String remark = null;
  
  
  @ApiModelProperty(name="shopCode", value = "发货店铺编码")
  @JsonProperty("shopCode")
  private String shopCode = null;
  
  
  @ApiModelProperty(name="shopId", value = "发货店铺ID")
  @JsonProperty("shopId")
  private String shopId = null;
  
  
  @ApiModelProperty(name="shopName", value = "发货店铺名称")
  @JsonProperty("shopName")
  private String shopName = null;
  
}

