package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.RpInventoryPreemptionQueryDto;
import com.dtyunxi.tcbj.api.dto.response.RpInventoryPreemptionRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(tags = {"CsInventoryPreemption接口"})

@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-query-ICsInventoryPreemptionQueryApi",
        name = "${tcbj.center.report.name:tcbj-center-report}",
        path = "/v1/csInventoryPreemption",
        url = "${tcbj.center.report.api:}"
)
public interface ICsInventoryPreemptionQueryApi {

    @PostMapping(value = "/queryPage", produces = "application/json")
    @ApiOperation(value = "查询库存中心预占信息（分页）", notes = "查询中心库存预占信息（分页）")
    RestResponse<PageInfo<RpInventoryPreemptionRespDto>> queryPage(@RequestBody RpInventoryPreemptionQueryDto queryDto);

    @PostMapping(value = "/preemptedQueryPage", produces = "application/json")
    @ApiOperation(value = "预占库存总查询(分页)", notes = "预占库存总查询(分页)")
    RestResponse<PageInfo<RpInventoryPreemptionRespDto>> preemptedQueryPage(@RequestBody RpInventoryPreemptionQueryDto queryDto);

    @PostMapping(value = "/inventoryPreemptionCount", produces = "application/json")
    @ApiOperation(value = "预占库存数量统计", notes = "预占库存数量统计")
    RestResponse<RpInventoryPreemptionRespDto> inventoryPreemptionCount(@RequestBody RpInventoryPreemptionQueryDto queryDto);
}
