/**
 * @(#)CsInventoryPreemptionQueryApi.java 1.0 2022/02/14 15:22
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.query;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.ShInventoryPreemptionQueryDto;
import com.dtyunxi.tcbj.api.dto.response.ShInventoryPreemptionRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
* CsInventoryPreemptionQueryApi
*
* @author jingran
* @Date: 2022/02/14 15:22
* @since 1.0.0
*/
@Api(tags = {"ShInventoryPreemption接口"})

@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-query-IShInventoryPreemptionQueryApi",
        name = "${tcbj.center.report.name:tcbj-center-report}",
        path = "/v1/shInventoryPreemption",
        url = "${tcbj.center.report.api:}"
)
public interface IShInventoryPreemptionQueryApi {

    /**
     * 根据id查询信息
     * @param queryDto 入参
     * @return RestResponse<PageInfo<ShInventoryPreemptionRespDto>>
     */
    @PostMapping(value = "/queryPageInfo", produces = "application/json")
    @ApiOperation(value = "查询共享中心预占信息（分页）", notes = "查询共享中心预占信息（分页）")
    RestResponse<PageInfo<ShInventoryPreemptionRespDto>> queryPageInfo(@RequestBody ShInventoryPreemptionQueryDto queryDto);

}