package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.TmsSignForStatisticsReqDto;
import com.dtyunxi.tcbj.api.dto.response.TmsSignForStatisticsRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* TMS签收统计服务接口
*
* @author 天泽
* @since 2022-08-24
*/
@Api(tags = {"TMS签收统计服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-ITmsSignForStatisticsApi",
    name = "${tcbj.center.report.name:tcbj-center-report}",
    path = "/v1/tmsSignForStatistics",
    url = "${tcbj.center.report.api:}"
)
public interface ITmsSignForStatisticsApi {

/**
* 新增TMS签收统计
*
* @param addReqDto TMS签收统计请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增TMS签收统计", notes = "新增TMS签收统计")
RestResponse<Long> addTmsSignForStatistics(@RequestBody TmsSignForStatisticsReqDto addReqDto);

    /**
    * 修改TMS签收统计
    *
    * @param modifyReqDto TMS签收统计请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改TMS签收统计", notes = "修改TMS签收统计")
    RestResponse<Void> modifyTmsSignForStatistics(@RequestBody TmsSignForStatisticsReqDto modifyReqDto);

    /**
    * 删除TMS签收统计
    *
    * @param ids        TMS签收统计删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除TMS签收统计", notes = "删除TMS签收统计")
    RestResponse<Void> removeTmsSignForStatistics(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
