package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.response.ReportBaseRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author minyue
 * @description: 信用流水明细
 * @since 2022-01-19 17:41
 */
@Data
@ApiModel(value = "CreditRecordDetailReqDto", description = "信用流水明细")
public class CreditRecordDetailReqDto extends PageInfo<CreditRecordDetailReqDto> {

    @ApiModelProperty(name = "creditEntityCode", value = "授信主体编号")
    private String creditEntityCode;

    @ApiModelProperty(name = "customerCode", value = "客户编号")
    private String customerCode;

    @ApiModelProperty(name = "customerName", value = "客户编号")
    private String customerName;

    @ApiModelProperty(name = "creditRecordCode", value = "信用流水编号")
    private String creditRecordCode;

    @ApiModelProperty(name = "creditAccountCode", value = "信用账户")
    private String creditAccountCode;

    @ApiModelProperty(name = "changeTimeStart", value = "变动开始时间")
    private String changeTimeStart;

    @ApiModelProperty(name = "changeTimeEnd", value = "变动结束时间")
    private String changeTimeEnd;

    @ApiModelProperty(name = "orderNo", value = "关联单号")
    private String orderNo;

    private List<Long> organizationIds;

//    @ApiModelProperty(name = "pageNum", value = "页数")
//    private Integer pageNum = 1;
//
//    @ApiModelProperty(name = "pageSize", value = "每页条数")
//    private Integer pageSize = 10;
}
