package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.dto.BasePageDto;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@Data
@ApiModel(value = "DamageRateReportReqDto", description = "破损率报表请求dto")
public class DamageRateReportReqDto extends BasePageDto {

    @NotNull
    @ApiModelProperty(name = "pageSize", required = true, value = "")
    @JsonProperty("pageSize")
    private Integer pageSize;

    @NotNull
    @ApiModelProperty(name = "pageNum", required = true, value = "")
    @JsonProperty("pageNum")
    private Integer pageNum;

    @ApiModelProperty(name = "monthStr", value = "月份")
    @JsonProperty("monthStr")
    private String monthStr;

    @ApiModelProperty(name = "customerId", value = "承运商id")
    @JsonProperty("customerId")
    private String customerId;

    @ApiModelProperty(name = "customerCode", value = "承运商编号")
    @JsonProperty("customerCode")
    private String customerCode;

    @ApiModelProperty(name = "customerName", value = "承运商名称")
    @JsonProperty("customerName")
    private String customerName;
}
