package com.dtyunxi.tcbj.api.dto.request;

import java.util.Date;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.tcbj.api.dto.BaseDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
* 发货通知单请求dto
*
* @author wude
* @since 2022-03-08
*/
@ApiModel(value = "DeliveryNoticeOrderReqDto", description = "发货通知单请求dto")
@Data
public class DeliveryNoticeOrderReqDto extends BaseDto {
    @ApiModelProperty(name = "orderType", value = "单据类型：delivery-发货通知单，receive-收货通知单")
    private String orderType;

    /**
    *  单号
    */
    @ApiModelProperty(name = "documentNo", value = "单号")
    private String orderNo;
    /**
    *  业务类型
    */
    @ApiModelProperty(name = "businessType", value = "业务类型")
    private String businessType;
    /**
    *  单据状态,待定
    */
    @ApiModelProperty(name = "orderStatus", value = "单据状态,待定")
    private String orderStatus;

    /**
    *  发货仓库编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "发货仓库编码")
    private String warehouseCode;
    /**
    *  发货仓库名称
    */
    @ApiModelProperty(name = "warehouseName", value = "发货仓库名称")
    private String warehouseName;
    /**
     *  收货仓库名称
     */
    @ApiModelProperty(name = "receiveWarehouseName", value = "收货仓库名称")
    private String receiveWarehouseName;
    /**
    *  发货总数量
    */
    @ApiModelProperty(name = "totalQuantity", value = "发货总数量")
    private BigDecimal totalQuantity;
    /**
     * 创建开始时间
     */
    @ApiModelProperty(
            name = "createBeginTime",
            value = "创建开始时间"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date createBeginTime;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(
            name = "createEndTime",
            value = "创建结束时间"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private Date createEndTime;

    @ApiModelProperty(name="documentStatusList", value = "单据状态")
    @JsonProperty("documentStatusList")
    private List<String> documentStatusList;

    @ApiModelProperty(name="businessTypeList", value = "业务类型集合")
    @JsonProperty("businessTypeList")
    private List<String> businessTypeList;


}
