package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SgSourceLogReqDto;
import com.dtyunxi.tcbj.api.dto.response.SgSourceLogRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 寻源日志服务接口
*
* @author yuangui
* @since 2022-04-19
*/
@Api(tags = {"寻源日志服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-ISgSourceLogApi",
    name = "${tcbj.center.report.api.name:tcbj-center-report}",
    path = "/v1/sgSourceLog",
    url = "${tcbj.center.report.api:}"
)
public interface ISgSourceLogApi {

/**
* 新增寻源日志
*
* @param addReqDto 寻源日志请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增寻源日志", notes = "新增寻源日志")
RestResponse<Long> addSgSourceLog(@RequestBody SgSourceLogReqDto addReqDto);

    /**
    * 修改寻源日志
    *
    * @param modifyReqDto 寻源日志请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改寻源日志", notes = "修改寻源日志")
    RestResponse<Void> modifySgSourceLog(@RequestBody SgSourceLogReqDto modifyReqDto);

    /**
    * 删除寻源日志
    *
    * @param ids        寻源日志删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除寻源日志", notes = "删除寻源日志")
    RestResponse<Void> removeSgSourceLog(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
