package com.dtyunxi.tcbj.api.dto.request;

import com.dtyunxi.tcbj.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;


@Data
@ApiModel(value = "PhysicalInventoryReqDto", description = "物理仓可用报表查询请求dto")
public class PhysicalInventoryReqDto extends BaseDto {
    /**
     *  物理仓编码
     */
    @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓编码")
    private String physicsWarehouseCode;

    @ApiModelProperty(name = "physicsWarehouseCodeList", value = "物理仓编码")
    private List<String> physicsWarehouseCodeList;

    /**
     *  物理仓名称
     */
    @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓名称")
    private String physicsWarehouseName;

    @ApiModelProperty(name = "physicsWarehouseNameList", value = "物理仓名称")
    private List<String> physicsWarehouseNameList;
    /**
     *  仓库类型
     */
    @ApiModelProperty(name = "warehouseType", value = "仓库类型")
    private String warehouseType;
    /**
     *  商品长编码
     */
    @ApiModelProperty(name = "itemLongCode", value = "商品长编码")
    private String itemLongCode;
    /**
     *  商品名称
     */
    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "organizationName", value = "所属组织名称")
    private List<String> organizationNames;

    @ApiModelProperty(name = "itemName", value = "线上线下标识，线上-on_line   线下-off_line")
    private List<String> warehouseOnlineFlags;
    /**
     *  实际库存大于0
     */
    @ApiModelProperty(name = "waitInspectionAvailableType", value = "1.自定义, 2,大于0 3,等于0, 4.小于0 5,大于等于0 6.小于等于0")
    private Integer waitInspectionAvailableType;
    @ApiModelProperty(name = "waitInspectionAvailableStart", value = "待检可用库存开始范围")
    private BigDecimal waitInspectionAvailableStart;
    @ApiModelProperty(name = "waitInspectionAvailableEnd", value = "待检可用库存结束范围")
    private BigDecimal waitInspectionAvailableEnd;
    @ApiModelProperty(name = "waitInspectionAvailableEnd", value = "待检可用库存")
    private BigDecimal waitInspectionAvailable;

    @ApiModelProperty(name = "availableType", value = "总可用库存大于0 1.自定义, 2,大于0 3,等于0, 4.小于0 5,大于等于0 6.小于等于0")
    private Integer availableType;
    @ApiModelProperty(name = "availableStart", value = "总可用库存开始范围")
    private BigDecimal availableStart;
    @ApiModelProperty(name = "availableEnd", value = "总可用库存结束范围")
    private BigDecimal availableEnd;
    @ApiModelProperty(name = "available", value = "总可用库存")
    private BigDecimal available;

    @ApiModelProperty(name = "balanceType", value = "总即时库存大于0 1.自定义, 2,大于0 3,等于0, 4.小于0 5,大于等于0 6.小于等于0")
    private Integer balanceType;
    @ApiModelProperty(name = "balanceStart", value = "即时库存开始范围")
    private BigDecimal balanceStart;
    @ApiModelProperty(name = "balanceEnd", value = "即时库存结束范围")
    private BigDecimal balanceEnd;
    @ApiModelProperty(name = "balance", value = "总即时库存")
    private BigDecimal balance;

    @ApiModelProperty(name = "preemptQueryType", value = "预占库存查询类型 1.自定义, 2,大于0 3,等于0, 4.小于0 5,大于等于0 6.小于等于0")
    private Integer preemptQueryType;
    @ApiModelProperty(name = "preemptStart", value = "预占库存开始范围")
    private BigDecimal preemptStart;
    @ApiModelProperty(name = "preemptEnd", value = "预占库存结束范围")
    private BigDecimal preemptEnd;
    @ApiModelProperty(name = "preempt", value = "预占库存")
    private BigDecimal preempt;

    @ApiModelProperty(name = "lockInventoryType", value = "锁定库存查询类型 1.自定义, 2,大于0 3,等于0, 4.小于0 5,大于等于0 6.小于等于0")
    private Integer lockInventoryType;
    @ApiModelProperty(name = "lockInventoryStart", value = "锁定库存开始范围")
    private BigDecimal lockInventoryStart;
    @ApiModelProperty(name = "lockInventoryEnd", value = "锁定库存结束范围")
    private BigDecimal lockInventoryEnd;
    @ApiModelProperty(name = "lockInventory", value = "锁定库存")
    private BigDecimal lockInventory;




}
