package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderAmountReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleReturnDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleSpOrderSyncReqDto;
import com.dtyunxi.tcbj.api.dto.response.*;
import com.dtyunxi.tcbj.api.dto.response.SaleReturnDetailRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 销售订单表服务接口
 *
 * @author haoxiao
 * @since 2022-03-10
 */
@Api(tags = {"销售订单报表服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/saleOrderReport", url = "${tcbj.center.report.api:}")
public interface ISaleOrderReportQueryApi {

    /**
     * 销售订单表分页数据
     *
     * @param filter   销售订单表查询条件
     * @return 销售订单表分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "销售订单分页数据", notes = "根据filter查询条件查询销售订单表数据，filter=SaleOrderReqDto")
    RestResponse<PageInfo<SaleOrderRespDto>> queryByPage(@RequestBody SaleOrderReqDto filter);


    /**
     * 销售订单各状态的订单数量
     *
     * @param filter   销售订单表查询条件
     * @return 销售订单表分页数据
     */
    @PostMapping("/queryByCount")
    @ApiOperation(value = "销售订单各状态的订单数量", notes = "根据filter查询条件查询销售订单表统计数据，filter=SaleOrderReqDto")
    RestResponse<SaleOrderCountRespDto> queryByCount(@RequestBody SaleOrderReqDto filter);

    @PostMapping("/queryStringCodeByCount")
    @ApiOperation(value = "销售订单串码各状态的订单数量", notes = "根据filter查询条件查询销售订单表统计数据，filter=SaleOrderReqDto")
    RestResponse<SaleOrderStringCodeCountRespDto> queryStringCodeByCount(@RequestBody SaleOrderReqDto filter);

    @PostMapping("/queryCountAndAmount")
    @ApiOperation(value = "销售订单金额统计", notes = "销售订单金额统计")
    RestResponse<SaleOrderAmountDto> queryAmountInfo(@RequestBody SaleOrderAmountReqDto filter);

    @PostMapping("/verifySaleOrderEntireSign")
    @ApiOperation(value = "校验销售单是否完全签收（根据主单号判断）", notes = "校验销售单是否完全签收（根据主单号判断）")
    RestResponse<Boolean> verifySaleOrderEntireSign(@RequestBody SaleOrderReqDto reqDto);

    @PostMapping("/verifySaleOrderEntireReceiveDelivery")
    @ApiOperation(value = "校验销售单是否完全收发货（根据主单号判断）", notes = "校验销售单是否完全收发货（根据主单号判断）")
    RestResponse<Boolean> verifySaleOrderEntireReceiveDelivery(@RequestBody SaleOrderReqDto reqDto);

    @PostMapping("/getTransferSaleOrder")
    RestResponse<SaleOrderRespDto> getTransferSaleOrder(@RequestParam("orderNo") String transferOrderNo);

    @GetMapping("/verifySaleOrderEntireReceiveDeliveryPlatform")
    @ApiOperation(value = "校验销售单是否完全收发货（根据平台父单号判断）", notes = "校验销售单是否完全收发货（根据平台父单号判断）")
    RestResponse<Boolean> verifySaleOrderEntireReceiveDeliveryPlatform(@RequestParam("platformParentOrderNo") String platformParentOrderNo);

    @GetMapping("/verifySaleOrderEntireSignPlatform")
    @ApiOperation(value = "校验销售单是否完全签收（根据平台父单号判断）", notes = "校验销售单是否完全签收（根据平台父单号判断）")
    RestResponse<Boolean> verifySaleOrderEntireSignPlatform(@RequestParam("platformParentOrderNo") String platformParentOrderNo);

    @PostMapping("/querySaleOrderByTag")
    @ApiOperation(value = "根据客户id，组织id，标签编码查询销售订单", notes = "根据客户id，组织id，标签编码查询销售订单")
    RestResponse<List<SaleOrderRespDto>> querySaleOrderByTag(@RequestBody SaleOrderReqDto filter);

    @PostMapping("/querySaleCompensationOrderList")
    @ApiOperation(value = "查询索赔单eas单号，实际客户信息(推送到csp使用)", notes = "查询索赔单eas单号，实际客户信息(推送到csp使用)")
    RestResponse<List<SaleCompensationOrderSyncDto>> querySaleCompensationOrderList(SaleSpOrderSyncReqDto dto);

    @PostMapping("/specialChannelOrderStringCodeData")
    @ApiOperation(value = "查询特渠订单未校验串码的订单号", notes = "查询特渠订单未校验串码的订单号")
    RestResponse<List<SaleOrderRespDto>> specialChannelOrderStringCodeData();

    @PostMapping("/saleReturnDetailReportPage")
    @ApiOperation(value = "销售退货明细报表分页", notes = "销售退货明细报表分页")
    RestResponse<PageInfo<SaleReturnDetailRespDto>> saleReturnDetailReportPage(@RequestBody SaleReturnDetailReqDto req);
}
