package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.FeeReportPlaceUpdateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ReInsurancePremiumReqDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.dtyunxi.tcbj.api.dto.response.ReInsurancePremiumRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

/**
* 保费明细表服务接口
*
* @author lshaowu
* @since 2022-07-18
*/
@Api(tags = {"保费明细表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IReInsurancePremiumQueryApi",
    name = "tcbj-center-report",
    path = "/v1/reInsurancePremium",
    url = "${tcbj.center.report.api:}"
)
public interface IReInsurancePremiumQueryApi {

    /**
    * 根据id查询保费明细表
    *
    * @param id 保费明细表id
    * @return   保费明细表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询保费明细表", notes = "根据id查询保费明细表")
    RestResponse<ReInsurancePremiumRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 保费明细表分页数据
    *
    * @param filter   保费明细表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 保费明细表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "保费明细表分页数据", notes = "根据filter查询条件查询保费明细表数据，filter=ReInsurancePremiumReqDto")
    RestResponse<PageInfo<ReInsurancePremiumRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 保费明细更新归档标识
     * @param updateReqDto
     * @return
     */
    @PostMapping("/updatePlaceStatus")
    @ApiOperation(value = "保费明细更新归档标识", notes = "保费明细更新归档标识")
    RestResponse<Integer> updatePlaceStatus(@RequestBody @Validated FeeReportPlaceUpdateReqDto updateReqDto);

    @PostMapping("/queryFlagCount")
    @ApiOperation(value = "保费明细异常统计", notes = "保费明细异常统计")
    RestResponse<ReInsuranceBillCountDto> queryFlagCount(@RequestBody ReInsurancePremiumReqDto reqDto);
}
