package com.dtyunxi.tcbj.api.dto.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel(value = "SaleReturnDetailRespDto", description = "销售退货明细报表返回")
public class SaleReturnDetailRespDto {

    @ApiModelProperty(name = "sapOutOrderNo", value = "SAP交货单号")
    @JsonProperty("sapOutOrderNo")
    private String sapOutOrderNo;

    @ApiModelProperty(name = "sapOrderNo", value = "SAP销售单号")
    @JsonProperty("sapOrderNo")
    private String sapOrderNo;

    @ApiModelProperty(name = "platformRefundNo", value = "营销云单号")
    @JsonProperty("platformRefundNo")
    private String platformRefundNo;

    @ApiModelProperty(name = "saleRefundNo", value = "OCS退货单号")
    @JsonProperty("saleRefundNo")
    private String saleRefundNo;

    @ApiModelProperty(name = "organizationCode", value = "销售组织")
    @JsonProperty("organizationCode")
    private String organizationCode;

    @ApiModelProperty(name = "organizationName", value = "销售组织名称")
    @JsonProperty("organizationName")
    private String organizationName;

    @ApiModelProperty(name = "receiveLogicWarehouseCode", value = "发货库存地点编码")
    @JsonProperty("receiveLogicWarehouseCode")
    private String receiveLogicWarehouseCode;

    @ApiModelProperty(name = "receiveLogicWarehouseName", value = "发货库存地点名称")
    @JsonProperty("receiveLogicWarehouseName")
    private String receiveLogicWarehouseName;

    @ApiModelProperty(name = "customerCode", value = "退货客户编码")
    @JsonProperty("customerCode")
    private String customerCode;

    @ApiModelProperty(name = "customerName", value = "退货客户名称")
    @JsonProperty("customerName")
    private String customerName;

    @ApiModelProperty(name = "skuCode", value = "物料编号")
    @JsonProperty("skuCode")
    private String skuCode;

    @ApiModelProperty(name = "skuName", value = "物料名称")
    @JsonProperty("skuName")
    private String skuName;

    @ApiModelProperty(name = "batch", value = "物料批次")
    @JsonProperty("batch")
    private String batch;

    @ApiModelProperty(name = "quantity", value = "数量")
    @JsonProperty("quantity")
    private Integer quantity;

    @ApiModelProperty(name = "createTime", value = "入库时间")
    @JsonProperty("createTime")
    private String createTime;
}


