package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.LogicWarehouseReqDto;
import com.dtyunxi.tcbj.api.dto.request.WarehouseThresholReqDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseOrgRespDto;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.tcbj.api.dto.response.PhysicsWarehouseRespDto;
import com.dtyunxi.tcbj.api.dto.response.WarehouseThresholdRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 逻辑仓服务接口
*
* @author wude
* @since 2022-03-07
*/
@Api(tags = {"逻辑仓服务"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/report", url = "${tcbj.center.report.api:}")
public interface ILogicWarehouseQueryApi {

    /**
    * 根据id查询逻辑仓
    *
    * @param id 逻辑仓id
    * @return   逻辑仓数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询逻辑仓", notes = "根据id查询逻辑仓")
    RestResponse<LogicWarehouseRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 逻辑仓分页数据
    *
    * @param filter   逻辑仓查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 逻辑仓分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "逻辑仓分页数据", notes = "根据filter查询条件查询逻辑仓数据，filter=LogicWarehouseReqDto")
    RestResponse<PageInfo<LogicWarehouseRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 逻辑仓分页数据
     *
     * @param reqDto   逻辑仓查询条件
     * @return 逻辑仓分页数据
     */
    @PostMapping("/post/page")
    @ApiOperation(value = "逻辑仓分页数据", notes = "根据filter查询条件查询逻辑仓数据，filter=LogicWarehouseReqDto")
    RestResponse<PageInfo<LogicWarehouseRespDto>> queryByPageByPost(@RequestBody LogicWarehouseReqDto reqDto);

    /**
     * 统计获取当应前逻辑仓对物理仓的出库单量
     *
     *
     * @return 出库结果单分页数据
     */
    @PostMapping("/queryWarehouseThreshold")
    @ApiOperation(value = "统计获取当应前逻辑仓对物理仓的出库单量", notes = "统计获取当应前逻辑仓对物理仓的出库单量,filter=warehouseCodes")
    RestResponse<List<WarehouseThresholdRespDto>> queryWarehouseThreshold(@RequestBody WarehouseThresholReqDto reqDto);

    /**
     * 根据仓库名称查询逻辑仓
     *
     * @return 逻辑仓
     */
    @PostMapping("/queryWarehouseByName")
    @ApiOperation(value = "根据仓库名称查询逻辑仓", notes = "根据仓库名称查询逻辑仓")
    RestResponse<List<LogicWarehouseRespDto>> queryWarehouseByName(@RequestBody List<String> warehouseNames);
  /**
     * 根据仓库编码查询逻辑仓
     *
     * @return 逻辑仓
     */
    @PostMapping("/queryWarehouseByCode")
    @ApiOperation(value = "根据仓库编码查询逻辑仓", notes = "根据仓库编码查询逻辑仓")
    RestResponse<List<LogicWarehouseRespDto>> queryWarehouseByCode(@RequestBody List<String> warehouseCodes);

    @PostMapping("/queryInTransitWarehouseByCode")
    @ApiOperation(value = "根据仓库编码查询在途仓", notes = "根据仓库编码查询在途仓")
    RestResponse<List<LogicWarehouseRespDto>> queryInTransitWarehouseByCode(@RequestBody List<String> warehouseCodes);

    @PostMapping("/queryOrgList")
    @ApiOperation(value = "查询库存组织", notes = "查询库存组织")
    RestResponse<List<LogicWarehouseOrgRespDto>> queryOrgList();

    @PostMapping("/queryPhysicsWarehouse")
    @ApiOperation(value = "查询所有物理仓", notes = "查询所有物理仓")
    RestResponse<List<PhysicsWarehouseRespDto>> queryPhysicsWarehouse();


}
