package com.dtyunxi.tcbj.api.dto.response;

import java.util.Date;
import com.dtyunxi.dto.ResponseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.dtyunxi.dto.BaseRespDto;

import javax.persistence.Column;

/**
* 仓储账单表Eo对象
*
* @author by_liusong
* @since 2022-07-15
*/
@ApiModel(value = "StorageChargeBillRespDto", description = "仓储账单表Eo对象")
public class StorageChargeBillRespDto extends BaseRespDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  账单月份
    */
    @ApiModelProperty(name = "billTime", value = "账单月份")
    private Date billTime;
    /**
    *  关联合同id
    */
    @ApiModelProperty(name = "contractId", value = "关联合同id")
    private Long contractId;
    /**
    *  物理仓编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "物理仓编码")
    private String warehouseCode;
    /**
    *  物理仓名称
    */
    @ApiModelProperty(name = "warehouseName", value = "物理仓名称")
    private String warehouseName;
    /**
    *  逻辑仓编码
    */
    @ApiModelProperty(name = "logicWarehouseCode", value = "逻辑仓编码")
    private String logicWarehouseCode;
    /**
    *  逻辑仓名称
    */
    @ApiModelProperty(name = "logicWarehouseName", value = "逻辑仓名称")
    private String logicWarehouseName;
    /**
    *  计费库存组织ID
    */
    @ApiModelProperty(name = "chargeOrgId", value = "计费库存组织ID")
    private String chargeOrgId;
    /**
    *  计费库存组织名称
    */
    @ApiModelProperty(name = "chargeOrgName", value = "计费库存组织名称")
    private String chargeOrgName;
    /**
    *  月实际总板数
    */
    @ApiModelProperty(name = "allMonthSupport", value = "月实际总板数")
    private BigDecimal allMonthSupport;
    /**
    *  合同每月日均板数
    */
    @ApiModelProperty(name = "contractAverageSupport", value = "合同每月日均板数")
    private BigDecimal contractAverageSupport;
    /**
    *  当月天数
    */
    @ApiModelProperty(name = "daysNum", value = "当月天数")
    private Integer daysNum;
    /**
    *  是否满足合同约定;0:不满足;1:满足;
    */
    @ApiModelProperty(name = "isSatisfy", value = "是否满足合同约定;0:不满足;1:满足;")
    private Integer isSatisfy;
    /**
    *  单价
    */
    @ApiModelProperty(name = "unitPrice", value = "单价")
    private BigDecimal unitPrice;
    /**
    *  仓储费
    */
    @ApiModelProperty(name = "warehouseCost", value = "仓储费")
    private BigDecimal warehouseCost;
    /**
     *  出库体积
     */
    @ApiModelProperty(name = "outDeliveryVolume", value = "出库体积")
    private BigDecimal outDeliveryVolume;
    /**
     * 出库板数
     */
    @ApiModelProperty(name = "outDeliverySupport", value = "出库板数")
    private Integer outDeliverySupport;


    /**
     *  出库体积/板数
     */
    @ApiModelProperty(name = "outDeliveryProperty", value = "出库体积/板数")
    private BigDecimal outDeliveryProperty;
    /**
     *  体积/板数占比
     */
    @ApiModelProperty(name = "outPercentageProperty", value = "体积/板数占比")
    private BigDecimal outPercentageProperty;
    /**
    *  其他费用
    */
    @ApiModelProperty(name = "otherCost", value = "其他费用")
    private BigDecimal otherCost;
    /**
    *  合计仓储费
    */
    @ApiModelProperty(name = "totalWarehouseCost", value = "合计仓储费")
    private BigDecimal totalWarehouseCost;

    /**
     *  账单异常信息
     */
    @ApiModelProperty(name = "exceptionInfo", value = "账单异常信息")
    private String exceptionInfo;

    /**
     *  是否异常
     */
    @ApiModelProperty(name = "status", value = "是否异常")
    private Integer status;


    /**
    *  组织id
    */
    @ApiModelProperty(name = "orgId", value = "组织id")
    private Long orgId;
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;
    @ApiModelProperty(name = "billType", value = "单据类型")
    private Integer billType;

    /**
     *  是否已归档,0未归档,1已归档
     */
    @ApiModelProperty(name = "placedFlag", value = "是否已归档,0未归档,1已归档")
    private Integer placedFlag;

    public Integer getPlacedFlag() {
        return placedFlag;
    }

    public void setPlacedFlag(Integer placedFlag) {
        this.placedFlag = placedFlag;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getBillType() {
        return billType;
    }

    public void setBillType(Integer billType) {
        this.billType = billType;
    }

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setBillTime(Date billTime){
    this.billTime = billTime;
    }
    public Date getBillTime(){
    return this.billTime;
    }
    public void setContractId(Long contractId){
    this.contractId = contractId;
    }
    public Long getContractId(){
    return this.contractId;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setLogicWarehouseCode(String logicWarehouseCode){
    this.logicWarehouseCode = logicWarehouseCode;
    }
    public String getLogicWarehouseCode(){
    return this.logicWarehouseCode;
    }
    public void setLogicWarehouseName(String logicWarehouseName){
    this.logicWarehouseName = logicWarehouseName;
    }
    public String getLogicWarehouseName(){
    return this.logicWarehouseName;
    }
    public void setChargeOrgId(String chargeOrgId){
    this.chargeOrgId = chargeOrgId;
    }
    public String getChargeOrgId(){
    return this.chargeOrgId;
    }
    public void setChargeOrgName(String chargeOrgName){
    this.chargeOrgName = chargeOrgName;
    }
    public String getChargeOrgName(){
    return this.chargeOrgName;
    }
    public void setAllMonthSupport(BigDecimal allMonthSupport){
    this.allMonthSupport = allMonthSupport;
    }
    public BigDecimal getAllMonthSupport(){
    return this.allMonthSupport;
    }
    public void setContractAverageSupport(BigDecimal contractAverageSupport){
    this.contractAverageSupport = contractAverageSupport;
    }
    public BigDecimal getContractAverageSupport(){
    return this.contractAverageSupport;
    }
    public void setDaysNum(Integer daysNum){
    this.daysNum = daysNum;
    }
    public Integer getDaysNum(){
    return this.daysNum;
    }
    public void setIsSatisfy(Integer isSatisfy){
    this.isSatisfy = isSatisfy;
    }
    public Integer getIsSatisfy(){
    return this.isSatisfy;
    }
    public void setUnitPrice(BigDecimal unitPrice){
    this.unitPrice = unitPrice;
    }
    public BigDecimal getUnitPrice(){
    return this.unitPrice;
    }
    public void setWarehouseCost(BigDecimal warehouseCost){
    this.warehouseCost = warehouseCost;
    }
    public BigDecimal getWarehouseCost(){
    return this.warehouseCost;
    }
    public void setOutDeliveryVolume(BigDecimal outDeliveryVolume){
    this.outDeliveryVolume = outDeliveryVolume;
    }
    public BigDecimal getOutDeliveryVolume(){
    return this.outDeliveryVolume;
    }

    public Integer getOutDeliverySupport() {
        return outDeliverySupport;
    }

    public void setOutDeliverySupport(Integer outDeliverySupport) {
        this.outDeliverySupport = outDeliverySupport;
    }

    public BigDecimal getOutDeliveryProperty() {
        return outDeliveryProperty;
    }

    public void setOutDeliveryProperty(BigDecimal outDeliveryProperty) {
        this.outDeliveryProperty = outDeliveryProperty;
    }

    public BigDecimal getOutPercentageProperty() {
        return outPercentageProperty;
    }

    public void setOutPercentageProperty(BigDecimal outPercentageProperty) {
        this.outPercentageProperty = outPercentageProperty;
    }

    public void setOtherCost(BigDecimal otherCost){
    this.otherCost = otherCost;
    }
    public BigDecimal getOtherCost(){
    return this.otherCost;
    }
    public void setTotalWarehouseCost(BigDecimal totalWarehouseCost){
    this.totalWarehouseCost = totalWarehouseCost;
    }
    public BigDecimal getTotalWarehouseCost(){
    return this.totalWarehouseCost;
    }
    public void setOrgId(Long orgId){
    this.orgId = orgId;
    }
    public Long getOrgId(){
    return this.orgId;
    }

    public String getExceptionInfo() {
        return exceptionInfo;
    }

    public void setExceptionInfo(String exceptionInfo) {
        this.exceptionInfo = exceptionInfo;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
