/**
 * @(#)ILockOrderQueryApi.java 1.0 2022/05/30 15:48
 * <p>
 * Copyright (c) 2022, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.LockLogQueryDto;
import com.dtyunxi.tcbj.api.dto.request.LockOrderQueryDto;
import com.dtyunxi.tcbj.api.dto.response.LockLogRespDto;
import com.dtyunxi.tcbj.api.dto.response.LockOrderRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


/**
* ILockOrderQueryApi
*
* @author wenyi
* @Date: 2022/05/30 15:48
* @since 1.0.0
*/
@Api(tags = {"报表中心：查询锁库单信息"})
@FeignClient(name = "${tcbj.center.report.name:tcbj-center-report}", path = "/v1/lockOrder", url = "${tcbj.center.report.api:}")
public interface ILockOrderQueryApi {
    /**
     * 分页查询库存锁库管理列表
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询库存锁库管理列表", notes = "分页查询库存锁库管理列表")
    RestResponse<PageInfo<LockOrderRespDto>> queryByPage(@Validated @RequestBody LockOrderQueryDto queryDto);

    /**
     * 分页查询锁定记录报表
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/log/page", produces = "application/json")
    @ApiOperation(value = "分页查询锁定记录报表", notes = "分页查询锁定记录报表")
    RestResponse<PageInfo<LockLogRespDto>> queryLogByPage(@Validated @RequestBody LockLogQueryDto queryDto);
}