/**
 * @(#) SaleOrderVO.java 1.0 2022/1/5/005
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.tcbj.api.dto.response.es;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * SaleOrderVO
 */
@Data
@ApiModel(value = "SaleOrderRespEsVo", description = "")
public class SaleOrderRespEsVo {
  
  @ApiModelProperty(name="createTime", value = "创建时间")
  @JsonProperty("createTime")
  private String createTime;
  
  
  @ApiModelProperty(name="updateTime", value = "更新时间")
  @JsonProperty("updateTime")
  private String updateTime;
  
  
  @ApiModelProperty(name="createPerson", value = "创建人")
  @JsonProperty("createPerson")
  private String createPerson;
  
  
  @ApiModelProperty(name="updatePerson", value = "更新人")
  @JsonProperty("updatePerson")
  private String updatePerson;
  
  
  @ApiModelProperty(name="id", value = "唯一id")
  @JsonProperty("id")
  private Long id;

  @ApiModelProperty(name = "platformOrderId",value = "平台订单ID")
  private String platformOrderId;
  
  @ApiModelProperty(name="platformOrderNo", value = "平台订单号")
  @JsonProperty("platformOrderNo")
  private String platformOrderNo;
  
  
  @ApiModelProperty(name="saleOrderNo", value = "内部销售订单号")
  @JsonProperty("saleOrderNo")
  private String saleOrderNo;
  
  
  @Valid 
  @ApiModelProperty(name="orderLevel", value = "订单级别（0原、1主、2子）")
  @JsonProperty("orderLevel")
  private Integer orderLevel;
  
  
  @ApiModelProperty(name="shopName", value = "店铺名称")
  @JsonProperty("shopName")
  private String shopName;
  
  
  @ApiModelProperty(name="shopChannel", value = "店铺渠道")
  @JsonProperty("shopChannel")
  private String shopChannel;
  
  
  @ApiModelProperty(name="customerName", value = "客户名称")
  @JsonProperty("customerName")
  private String customerName;
  
  
  @ApiModelProperty(name="orderRemark", value = "订单备注")
  @JsonProperty("orderRemark")
  private String orderRemark;
  
  
  @ApiModelProperty(name="sellerRemark", value = "商家备注")
  @JsonProperty("sellerRemark")
  private String sellerRemark;
  
  
  @Valid 
  @ApiModelProperty(name="orderAddress", value = "")
  @JsonProperty("orderAddress")
  private AddressVO orderAddress;
  
  
  @ApiModelProperty(name="deliveryName", value = "收件人姓名")
  @JsonProperty("deliveryName")
  private String deliveryName;
  
  
  @ApiModelProperty(name="deliveryPhone", value = "收件人电话")
  @JsonProperty("deliveryPhone")
  private String deliveryPhone;
  
  @ApiModelProperty(name="platformCreateTime", value = "平台创建时间/下单时间")
  @JsonProperty("platformCreateTime")
  private String platformCreateTime;
  
  
  @ApiModelProperty(name="saleOrderCreateTime", value = "内部销售订单创建时间")
  @JsonProperty("saleOrderCreateTime")
  private String saleOrderCreateTime;
  
  
  @ApiModelProperty(name="confirmReceiveTime", value = "确认收货时间")
  @JsonProperty("confirmReceiveTime")
  private String confirmReceiveTime;
  
  
  @ApiModelProperty(name="needHandleReason", value = "需人工操作原因")
  @JsonProperty("needHandleReason")
  private String needHandleReason;
  
  
  @Valid 
  @ApiModelProperty(name="orderTotalAmount", value = "订单应收金额")
  @JsonProperty("orderTotalAmount")
  private BigDecimal orderTotalAmount;
  
  
  @Valid 
  @ApiModelProperty(name="payAmount", value = "支付金额")
  @JsonProperty("payAmount")
  private BigDecimal payAmount;
  
  
  @Valid 
  @ApiModelProperty(name="goodsTotalAmount", value = "商品总金额")
  @JsonProperty("goodsTotalAmount")
  private BigDecimal goodsTotalAmount;
  
  
  @ApiModelProperty(name="payWay", value = "支付方式")
  @JsonProperty("payWay")
  private String payWay;
  
  
  @ApiModelProperty(name="payStatus", value = "支付状态")
  @JsonProperty("payStatus")
  private String payStatus;
  
  
  @ApiModelProperty(name="payTime", value = "支付时间")
  @JsonProperty("payTime")
  private String payTime;
  
  
  @Valid 
  @ApiModelProperty(name="payableAmount", value = "客户应付金额")
  @JsonProperty("payableAmount")
  private BigDecimal payableAmount;
  
  
  @Valid 
  @ApiModelProperty(name="orderSteps", value = "订单进度")
  @JsonProperty("orderSteps")
  private List<OrderStepVO> orderSteps = null;
  
  
  @ApiModelProperty(name="orderType", value = "订单类型")
  @JsonProperty("orderType")
  private String orderType;
  
  
  @ApiModelProperty(name="saleOrderStatus", value = "内部销售订单状态")
  @JsonProperty("saleOrderStatus")
  private String saleOrderStatus;
  
  
  @ApiModelProperty(name="cancelReason", value = "取消原因")
  @JsonProperty("cancelReason")
  private String cancelReason;
  
  
  @Valid 
  @ApiModelProperty(name="goodsTotalNum", value = "明细数量汇总（商品总数量）")
  @JsonProperty("goodsTotalNum")
  private BigDecimal goodsTotalNum;
  
  
  @Valid 
  @ApiModelProperty(name="skuTotalNum", value = "sku数量")
  @JsonProperty("skuTotalNum")
  private BigDecimal skuTotalNum;
  
  
  @Valid 
  @ApiModelProperty(name="totalBoxNum", value = "总箱数")
  @JsonProperty("totalBoxNum")
  private BigDecimal totalBoxNum;
  
  
  @Valid 
  @ApiModelProperty(name="joinBoxNum", value = "拼箱数")
  @JsonProperty("joinBoxNum")
  private BigDecimal joinBoxNum;
  
  @ApiModelProperty(name="orderSource", value = "订单来源")
  @JsonProperty("orderSource")
  private String orderSource;
  
  
  @Valid 
  @ApiModelProperty(name="auditResult", value = "审核结果（0拒绝、1通过）")
  @JsonProperty("auditResult")
  private BigDecimal auditResult;
  
  
  @Valid 
  @ApiModelProperty(name="bunchCodeFlag", value = "串码（0不读取、1读取、2已读取）")
  @JsonProperty("bunchCodeFlag")
  private BigDecimal bunchCodeFlag;
  
  
  @Valid 
  @ApiModelProperty(name="volume", value = "体积（立方米）")
  @JsonProperty("volume")
  private BigDecimal volume;
  
  
  @Valid 
  @ApiModelProperty(name="weight", value = "重量（千克）")
  @JsonProperty("weight")
  private BigDecimal weight;
  
  
  @ApiModelProperty(name="rdcInfo", value = "RDC信息")
  @JsonProperty("rdcInfo")
  private String rdcInfo;
  
  
  @Valid 
  @ApiModelProperty(name="onlineFlag", value = "是否线上（0否、1是）")
  @JsonProperty("onlineFlag")
  private BigDecimal onlineFlag;
  
  
  @ApiModelProperty(name="deliveryWay", value = "发货方式（配送方式）")
  @JsonProperty("deliveryWay")
  private String deliveryWay;
  
  
  @ApiModelProperty(name="preDeliveryTime", value = "预计发货时间")
  @JsonProperty("preDeliveryTime")
  private String preDeliveryTime;
  
  
  @ApiModelProperty(name="logisticsCompany", value = "承运商（物流公司）")
  @JsonProperty("logisticsCompany")
  private String logisticsCompany;
  @ApiModelProperty(name="logisticsCompanyCode", value = "承运商（物流公司）")
  @JsonProperty("logisticsCompanyCode")
  private String logisticsCompanyCode;
  
  
  @ApiModelProperty(name="logisticsNo", value = "托运单号")
  @JsonProperty("logisticsNo")
  private String logisticsNo;

  @ApiModelProperty(name="shippingNo", value = "快递单号")
  @JsonProperty("shippingNo")
  private String shippingNo;

  
  @ApiModelProperty(name="sellerName", value = "发货方")
  @JsonProperty("sellerName")
  private String sellerName;
  
  
  @ApiModelProperty(name="saleChannel", value = "经销渠道")
  @JsonProperty("saleChannel")
  private String saleChannel;
  
  
  @ApiModelProperty(name="customerCode", value = "客户编码")
  @JsonProperty("customerCode")
  private String customerCode;
  
  
  @ApiModelProperty(name="preArriveTime", value = "预计达到时间")
  @JsonProperty("preArriveTime")
  private String preArriveTime;



  @ApiModelProperty(name ="interceptInfoFlag",value = "拦截信息标识（0:否，1:是）")
  private String interceptInfoFlag;

  @ApiModelProperty(name="interceptInfo", value = "拦截信息")
  @JsonProperty("interceptInfo")
  private String interceptInfo;

  
  @ApiModelProperty(name="pushOrderTime", value = "PCP推单时间")
  @JsonProperty("pushOrderTime")
  private String pushOrderTime;
  
  
  @ApiModelProperty(name="deliveryTime", value = "发货时间")
  @JsonProperty("deliveryTime")
  private String deliveryTime;
  
  
  @ApiModelProperty(name="deliveryNoticeOrderNo", value = "发货通知单号")
  @JsonProperty("deliveryNoticeOrderNo")
  private String deliveryNoticeOrderNo;
  
  
  @ApiModelProperty(name="deliveryNoticeOrderStatus", value = "发货通知单的状态")
  @JsonProperty("deliveryNoticeOrderStatus")
  private String deliveryNoticeOrderStatus;
  
  
  @ApiModelProperty(name="outNoticeOrderNo", value = "出库通知单号")
  @JsonProperty("outNoticeOrderNo")
  private String outNoticeOrderNo;
  
  
  @ApiModelProperty(name="outNoticeOrderStatus", value = "出库通知单的状态")
  @JsonProperty("outNoticeOrderStatus")
  private String outNoticeOrderStatus;
  
  
  @ApiModelProperty(name="logicalWarehouseName", value = "逻辑仓名称")
  @JsonProperty("logicalWarehouseName")
  private String logicalWarehouseName;

  @ApiModelProperty( name = "defaultLogicalWarehouseName",value = "默认逻辑仓")
  private String defaultLogicalWarehouseName;

  @ApiModelProperty( name = "allowSplitFlag",value = "是否接受拆单 0-否 1-是")
  private Integer allowSplitFlag;

  @ApiModelProperty( name = "originalOrderNo",value = "原订单号（订单被拆分前对应的订单号）")
  private String originalOrderNo;

  @ApiModelProperty( name = "splitStatus",value = "拆分状态：0-未拆分 1-已拆分")
  private Integer splitStatus;

  @ApiModelProperty( name = "splitLevel",value = "拆单序号")
  private String splitLevel;

  @ApiModelProperty( name = "orderChannelName",value = "订单渠道名称")
  private String orderChannelName;

  @ApiModelProperty( name = "channelWarehouseName",value = "渠道仓名称")
  private String channelWarehouseName;

  /**
   *  挂起状态：0-未挂起 1-已挂起 2-挂起失败
   */
  @ApiModelProperty(name = "lockStatus", value = "挂起状态：0-未挂起 1-已挂起 2-挂起失败")
  @JsonProperty("lockStatus")
  private Integer lockStatus;

  @ApiModelProperty(name = "assignStatus", value = "指派转态：0未指派，1指派成功，2指派失败,默认0")
  @JsonProperty("assignStatus")
  private String assignStatus;

  /**
   *  组织id
   */
  @JsonProperty("organizationId")
  @ApiModelProperty(name = "organizationId", value = "组织id")
  private Long organizationId;
  /**
   *  组织code
   */
  @JsonProperty("organizationCode")
  @ApiModelProperty(name = "organizationCode", value = "组织code")
  private String organizationCode;
  /**
   *  组织名称
   */
  @JsonProperty("organizationName")
  @ApiModelProperty(name = "organizationName", value = "组织名称")
  private String organizationName;
  /**
   *  平台父订单号
   */
  @JsonProperty("platformParentOrderNo")
  @ApiModelProperty(name = "platformParentOrderNo", value = "平台父订单号")
  private String platformParentOrderNo;
  /**
   *  主订单
   */
  @JsonProperty("mainOrderNo")
  @ApiModelProperty(name = "mainOrderNo", value = "主订单")
  private String mainOrderNo;

  /**
   *  订单状态 WAIT_CHECK :待确认 WAIT_PICK ：待配货 LOCK_UN_DELIVERY :已锁未发 WAIT_DELIVERY:待发货 DELIVERED:已发货 COMPLETE:已完成 CANCEL:已取消 FINISH:已完结 SPLIT:被拆分 RECEIVED：已签收 OBSOLETE：已作废 WAIT_CUSTOMER_AUDIT待客服审核 WAIT_BUSINESS_AUDIT:待商务审核
   */
  @JsonProperty("orderStatus")
  @ApiModelProperty(name = "orderStatus", value = "订单状态 WAIT_CHECK :待确认 WAIT_PICK ：待配货 LOCK_UN_DELIVERY :已锁未发 WAIT_DELIVERY:待发货 DELIVERED:已发货 COMPLETE:已完成 CANCEL:已取消 FINISH:已完结 SPLIT:被拆分 RECEIVED：已签收 OBSOLETE：已作废 WAIT_CUSTOMER_AUDIT待客服审核 WAIT_BUSINESS_AUDIT:待商务审核")
  private String orderStatus;

  /**
   *  销售订单父订单
   */
  @JsonProperty("parentOrderNo")
  @ApiModelProperty(name = "parentOrderNo", value = "销售订单父订单")
  private String parentOrderNo;
  /**
   *  店铺id
   */
  @JsonProperty("shopId")
  @ApiModelProperty(name = "shopId", value = "店铺id")
  private Long shopId;

  /**
   *  店铺渠道ID
   */
  @JsonProperty("shopChannelId")
  @ApiModelProperty(name = "shopChannelId", value = "店铺渠道ID")
  private Long shopChannelId;

  /**
   *  组织id
   */
  @JsonProperty("orgId")
  @ApiModelProperty(name = "orgId", value = "组织id")
  private Long orgId;
  /**
   *  组织code
   */
  @JsonProperty("orgCode")
  @ApiModelProperty(name = "orgCode", value = "组织code")
  private String orgCode;
  /**
   *  组织名称
   */
  @JsonProperty("orgName")
  @ApiModelProperty(name = "orgName", value = "组织名称")
  private String orgName;
  /**
   *  线上/线下：0：线下 1: 线上
   */
  @JsonProperty("isOnline")
  @ApiModelProperty(name = "isOnline", value = "线上/线下：0：线下 1: 线上")
  private Integer isOnline;

  /**
   *  客户id
   */
  @JsonProperty("customerId")
  @ApiModelProperty(name = "customerId", value = "客户id")
  private Long customerId;

  /**
   *  销售订单创建时间
   */
  @JsonProperty("saleCreateTime")
  @ApiModelProperty(name = "saleCreateTime", value = "销售订单创建时间")
  private Date saleCreateTime;

  /**
   *  发货方式
   */
  @JsonProperty("deliveryType")
  @ApiModelProperty(name = "deliveryType", value = "发货方式")
  private String deliveryType;
  /**
   *  预计发货时间
   */
  @JsonProperty("planDeliveryTime")
  @ApiModelProperty(name = "planDeliveryTime", value = "预计发货时间")
  private Date planDeliveryTime;
  /**
   *  承运商
   */
  @JsonProperty("deliveryCompany")
  @ApiModelProperty(name = "deliveryCompany", value = "承运商")
  private String deliveryCompany;
  /**
   *  订单备注
   */
  @JsonProperty("remark")
  @ApiModelProperty(name = "remark", value = "订单备注 ")
  private String remark;

  /**
   *  买家备注
   */
  @JsonProperty("buyerRemark")
  @ApiModelProperty(name = "buyerRemark", value = "买家备注")
  private String buyerRemark;

  /**
   *  第三方id
   */
  @JsonProperty("thirdPartyId")
  @ApiModelProperty(name = "thirdPartyId", value = "第三方id")
  private String thirdPartyId;

  /**
   *  订单渠道编码
   */
  @JsonProperty("channelCode")
  @ApiModelProperty(name = "channelCode", value = "订单渠道编码")
  private String channelCode;
  /**
   *  订单渠道id
   */
  @JsonProperty("channelId")
  @ApiModelProperty(name = "channelId", value = "订单渠道id")
  private Long channelId;
  /**
   *  指定发货逻辑仓主键ID
   */
  @JsonProperty("logicalWarehouseId")
  @ApiModelProperty(name = "logicalWarehouseId", value = "指定发货逻辑仓主键ID")
  private Long logicalWarehouseId;
  /**
   *  指定发货逻辑仓编码
   */
  @JsonProperty("logicalWarehouseCode")
  @ApiModelProperty(name = "logicalWarehouseCode", value = "指定发货逻辑仓编码")
  private String logicalWarehouseCode;


  /**
   *  默认目标逻辑仓id
   */
  @JsonProperty("defaultLogicalWarehouseId")
  @ApiModelProperty(name = "defaultLogicalWarehouseId", value = "默认目标逻辑仓id")
  private Long defaultLogicalWarehouseId;
  /**
   *  默认目标逻辑仓code
   */
  @JsonProperty("defaultLogicalWarehouseCode")
  @ApiModelProperty(name = "defaultLogicalWarehouseCode", value = "默认目标逻辑仓code")
  private String defaultLogicalWarehouseCode;

  /**
   *  渠道仓编码
   */
  @JsonProperty("channelWarehouseCode")
  @ApiModelProperty(name = "channelWarehouseCode", value = "渠道仓编码")
  private String channelWarehouseCode;
  /**
   *  渠道仓id
   */
  @JsonProperty("channelWarehouseId")
  @ApiModelProperty(name = "channelWarehouseId", value = "渠道仓id")
  private Long channelWarehouseId;


  /**
   *  订单子状态 WAIT_PICK_UNLOCK-待配货未锁定  WAIT_PICK_LOCK_UN_APPOINT-已锁定待指派PART_OUT_DELIVERY-部分出库 ALL_OUT_DELIVERY-全部出库
   */
  @JsonProperty("secondOrderStatus")
  @ApiModelProperty(name = "secondOrderStatus", value = "订单子状态 WAIT_PICK_UNLOCK-待配货未锁定  WAIT_PICK_LOCK_UN_APPOINT-已锁定待指派PART_OUT_DELIVERY-部分出库 ALL_OUT_DELIVERY-全部出库")
  private String secondOrderStatus;
  /**
   *  订单打标：MODIFY_LOGICAL_WAREHOUSE-修改逻辑仓, APPOINT_BATCH-指定批次, UN_LOCK-手工解锁, CANCEL_APPOINT-取消指派
   */
  @JsonProperty("optLabel")
  @ApiModelProperty(name = "optLabel", value = "订单打标：MODIFY_LOGICAL_WAREHOUSE-修改逻辑仓, APPOINT_BATCH-指定批次, UN_LOCK-手工解锁, CANCEL_APPOINT-取消指派")
  private String optLabel;
  /**
   *  订单全部发货完成时间
   */
  @JsonProperty("deliveryCompleteDate")
  @ApiModelProperty(name = "deliveryCompleteDate", value = "订单全部发货完成时间")
  private Date deliveryCompleteDate;
  /**
   *  生产日期
   */
  @JsonProperty("giveDate")
  @ApiModelProperty(name = "giveDate", value = "生产日期")
  private Date giveDate;
  /**
   *  到期日期
   */
  @JsonProperty("expireDate")
  @ApiModelProperty(name = "expireDate", value = "到期日期")
  private Date expireDate;
  /**
   *  物理仓仓库编码
   */
  @JsonProperty("warehouseCode")
  @ApiModelProperty(name = "warehouseCode", value = "物理仓仓库编码")
  private String warehouseCode;

  /**
   *  oms订单状态
   */
  @JsonProperty("omsSaleOrderStatus")
  @ApiModelProperty(name = "omsSaleOrderStatus", value = "oms订单状态")
  private String omsSaleOrderStatus;
  /**
   *  外部来源 B2B-B2B订单, THIRDPARTY-第三方订单
   */
  @JsonProperty("orderSourceModel")
  @ApiModelProperty(name = "orderSourceModel", value = "外部来源 B2B-B2B订单, THIRDPARTY-第三方订单")
  private String orderSourceModel;
  /**
   *  旗帜
   */
  @JsonProperty("flag")
  @ApiModelProperty(name = "flag", value = "旗帜")
  private String flag;
  /**
   *  买家昵称
   */
  @JsonProperty("buyerNickname")
  @ApiModelProperty(name = "buyerNickname", value = "买家昵称")
  private String buyerNickname;
  /**
   *  站点ID
   */
  @JsonProperty("siteId")
  @ApiModelProperty(name = "siteId", value = "站点ID")
  private Long siteId;
  /**
   *  站点code
   */
  @JsonProperty("siteCode")
  @ApiModelProperty(name = "siteCode", value = "站点code")
  private String siteCode;
  /**
   *  站点名称
   */
  @JsonProperty("siteName")
  @ApiModelProperty(name = "siteName", value = "站点名称")
  private String siteName;
  /**
   *  原始订单id
   */
  @JsonProperty("originOrderId")
  @ApiModelProperty(name = "originOrderId", value = "原始订单id")
  private Long originOrderId;

  @JsonProperty("ifEas")
  @ApiModelProperty(name = "ifEas", value = "是否财务后置单 0是1 否；默认0")
  private Integer ifEas;

  @JsonProperty("orderBizType")
  @ApiModelProperty(name = "orderBizType", value = "订单业务类型 0:普通订单,1:非药业-财务前置")
  private Integer orderBizType;

  @JsonProperty("easOrgId")
  @ApiModelProperty(name = "easOrgId", value = "EAS必须-组织编码")
  private String easOrgId;

  @JsonProperty("deliveryDate")
  @ApiModelProperty(name = "deliveryDate", value = "交货日期")
  private String deliveryDate;

  @JsonProperty("sendDate")
  @ApiModelProperty(name = "sendDate", value = "发货日期")
  private String sendDate;

  /**
   * 是否推送财务中台 0 否;1是 ,默认0
   */
  @JsonProperty("ifPullFinance")
  @ApiModelProperty(name = "ifPullFinance",value = "是否推送财务中台 0 否;1是 ,默认0")
  private Integer ifPullFinance;

  /**
   * eas单号
   */
  @JsonProperty("easOrderNo")
  @ApiModelProperty(name = "easOrderNo",value = "eas单号")
  private String easOrderNo;

  /**
   * 非药业财务前置单eas验证状态，0 未验证，1验证通过，默认0
   */
  @JsonProperty("easVerifyStatus")
  @ApiModelProperty(name = "easVerifyStatus",value = "非药业财务前置单eas验证状态，0 未验证，1验证通过，默认0")
  private Integer easVerifyStatus;

  /**
   * 前置是否预占库存 0否，1是,默认0
   */
  @JsonProperty("releaseState")
  @ApiModelProperty(name = "releaseState",value = "是否预占库存 0否，1是,默认0")
  private Integer releaseState;

  /**
   * 客户表easCode
   */
  @JsonProperty("easCode")
  @ApiModelProperty(name = "easCode",value = "客户表easCode")
  private String easCode;


  /**
   * 是否对接财务中台或eas平台 0否;1是，默认1
   */
  @JsonProperty("ifButtThirdParty")
  @ApiModelProperty(name = "ifButtThirdParty",value ="是否对接财务中台或eas平台 0否;1是，默认1" )
  private Integer ifButtThirdParty;

  /**
   * eas出库单号
   */
  @JsonProperty("easOutOrderNo")
  @ApiModelProperty(name = "easOutOrderNo",value = "eas出库单号")
  private String easOutOrderNo;

  /**
   *  物理仓编码
   */
  @JsonProperty("physicsWarehouseCode")
  @ApiModelProperty(name = "physicsWarehouseCode", value = "物理仓编码")
  private String physicsWarehouseCode;
  /**
   *  物理仓id
   */
  @JsonProperty("physicsWarehouseId")
  @ApiModelProperty(name = "physicsWarehouseId", value = "物理仓id")
  private Long physicsWarehouseId;
  /**
   *  物理仓名称
   */
  @JsonProperty("physicsWarehouseName")
  @ApiModelProperty(name = "physicsWarehouseName", value = "物理仓名称")
  private String physicsWarehouseName;

  /**
   *  拆分平台单号，-+拆分级别
   */
  @ApiModelProperty(name = "splitPlatformNo",value = "拆分平台单号，-+拆分级别")
  private String splitPlatformNo;

  /**
   * csp传下来的rdc物理仓(与rdc字段无关)
   */
  @ApiModelProperty(name = "storagePlace",value = "csp传下来的rdc物理仓(与rdc字段无关)")
  private String storagePlace;

  /**
   * 串码验证结果 0-未读取;1-读码异常;2-读码成功;默认0
   */
  @ApiModelProperty(name = "stringCodeResult",value = "串码验证结果 0-未读取;1-读码异常;2-读码成功;默认0")
  private String stringCodeResult;

  /**
   * 串码验证结果时间
   */
  @ApiModelProperty(name = "stringCodeTime",value = "串码验证结果时间")
  private Date stringCodeTime;
  /**
   * 指定供货仓id
   */
  @ApiModelProperty(name = "storagePlaceId",value = "指定供货仓id")
  private Long storagePlaceId;

  /**
   * 指定供货仓
   */
  @ApiModelProperty(name = "storagePlaceName",value = "指定供货仓名称")
  private String storagePlaceName;

  private String province;

  private String provinceCode;

  private String city;

  private String cityCode;

  private String county;

  private String countyCode;

  private String detailAddress;

  private String shippingJson;

  /**
   * 成本中心
   */
  @ApiModelProperty(name = "costCenterCode",value = "成本中心编码")
  private String costCenterCode;

  /**
   * 成本中心名称
   */
  @ApiModelProperty(name = "costCenterName",value = "成本中心名称")
  private String costCenterName;
  /**
   * eas验证更新时间
   */
  @ApiModelProperty(name = "easVerifyTime",value = "eas验证更新时间")
  private Date easVerifyTime;

    @ApiModelProperty(name = "easVerifyStatusList",value = "非药业财务前置单eas验证状态，0 未验证，1验证通过，默认0")
    private List<Integer> easVerifyStatusList;


    /**
     * 业务日期
     */
    @ApiModelProperty(name = "bizDate",value = "业务日期")
    private Date bizDate;


    @ApiModelProperty(name = "orderTags",value = "订单标签")
    private List<OrderTagRecordVo> orderTags;


  /**
   *  挂起类型：0-手工，1-系统（默认手工挂起）
   */
  @ApiModelProperty(name = "lockType",value = " 挂起类型：0-手工，1-系统（默认手工挂起）")
  private Integer lockType;

  @ApiModelProperty(name = "documentNo",value = "出库通知单")
  private String documentNo;


  /**
   * 区域编号
   */
  @ApiModelProperty(name = "regionCode", value = "区域编号")
  private String regionCode;
  /**
   * 区域名称
   */
  @ApiModelProperty(name = "regionName", value = "区域名称")
  private String regionName;

  /**
   * 事务类型id
   */
  @ApiModelProperty(name = "businessTypeId",value = "事务类型id")
  private Long businessTypeId;
  /**
   * 事务类型名称
   */
  @ApiModelProperty( name = "businessTypeName",value = "事务类型名称")
  private String businessTypeName;

  /**
   * 超期未发
   */
  @ApiModelProperty( name = "overdueDeliveryTime",value = "超期未发(分钟)")
  private Long overdueDeliveryTime;

  /**
   * 超期未发
   */
  @ApiModelProperty( name = "overdueDeliveryStr",value = "超期未发(xx小时xx分钟)")
  private String overdueDeliveryStr;

  /**
   * 超期未收
   */
  @ApiModelProperty( name = "overdueReceivedTime",value = "超期未收(分钟)")
  private Long overdueReceivedTime;
  /**
   * 超期未收
   */
  @ApiModelProperty( name = "overdueReceivedStr",value = "超期未收(xx天)")
  private String overdueReceivedStr;


  /**
   * 是否预占库存 0 ：否；1：是
   */
  @ApiModelProperty( name = "preemptionStock",value = "是否预占库存 0 ：否；1：是")
  private Integer preemptionStockFalg;

  @ApiModelProperty(name = "outTime", value = "出库时间")
  @JsonProperty("outTime")
  private String outTime;

  /**
   * 发货状态 undelivered 未发货；delivered 已发货
   */
  @ApiModelProperty(name = "deliveryStauts",value = "发货状态 undelivered 未发货；delivered 已发货")
  private String deliveryStauts;



  @ApiModelProperty(name = "transferWmsConsignmentNo", value = "转运托运单号")
  private String transferWmsConsignmentNo;

  @ApiModelProperty(name = "batchInverted", value = "是否批次倒挂")
  private Integer batchInverted;

  @ApiModelProperty(name = "volumeAndWeight", value = "体积与重量")
  private String volumeAndWeight;

  @ApiModelProperty(name = "allotType", value = "调拨方式")
  private String allotType;

  @ApiModelProperty(name = "allotOutWarehouseCode", value = "调出仓编码")
  private String allotOutWarehouseCode;

  @ApiModelProperty(name = "allotOutWarehouseName", value = "调出仓名称")
  private String allotOutWarehouseName;

  @ApiModelProperty(name = "allotInWarehouseCode", value = "调入仓编码")
  private String allotInWarehouseCode;

  @ApiModelProperty(name = "allotInWarehouseName", value = "调入仓名称")
  private String allotInWarehouseName;

  @ApiModelProperty(name = "wmsMergeDocumentNo", value = "wms合单号")
  private String wmsMergeDocumentNo;

  @ApiModelProperty(name = "joinMergeDocumentNo", value = "加入合单号")
  private String joinMergeDocumentNo;

  @ApiModelProperty(name="ifSourceWarehouseSpilt", value = "是否寻源拆单 0 否;1是 ,默认0")
  private Integer ifSourceWarehouseSpilt;

  @ApiModelProperty(name="myArrangeLogicalWarehouseCode", value = "指定逻辑仓编码（电商单场景）")
  private String myArrangeLogicalWarehouseCode;

  @ApiModelProperty(name="myArrangeLogicalWarehouseName", value = "指定逻辑仓名称（电商单场景）")
  private String myArrangeLogicalWarehouseName;


  @ApiModelProperty(name = "distributor", value = "配送商")
  private String distributor;

  @ApiModelProperty(name = "distributorUcc", value = "配送商信用代码")
  private String distributorUcc;
}

