package com.dtyunxi.tcbj.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.*;
import com.dtyunxi.tcbj.api.dto.response.ReInsuranceBillCountDto;
import com.dtyunxi.tcbj.api.dto.response.SortingCostReportRespDto;
import com.dtyunxi.tcbj.api.dto.response.SortingExpenseRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
* 分拣费用报表服务接口
*
* @author fengjian
* @since 2022-07-18
*/
@Api(tags = {"分拣费用报表服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-ISortingExpenseQueryApi",
    name = "${tcbj.center.report.name:tcbj-center-report}",
    path = "/v1/sortingExpense",
    url = "${tcbj.center.report.api:}"
)
public interface ISortingExpenseQueryApi {

    /**
     * 分拣费用报表分页数据
     *
     * @param sortingCostReportListPageReqDto   分拣费用报表查询条件、
     * @return 分拣费用报表分页数据
     */
    @PostMapping("/getSortingCostReportListPage")
    @ApiOperation(value = "分拣费用报表分页数据", notes = "根据filter查询条件查询分拣费用报表数据")
    RestResponse<PageInfo<SortingCostReportRespDto>> getSortingCostReportListPage(@RequestBody SortingCostReportListPageReqDto sortingCostReportListPageReqDto);

    /**
     * 生成分拣费用数据
     *
     * @param taskQueryParamsDro   生成分拣费用数据条件、
     * @return 生成分拣费用数据
     */
    @PostMapping("/executeJob")
    @ApiOperation(value = "分拣费用报表数据生成", notes = "分拣费用报表数据生成")
    RestResponse<Void> executeJob(@RequestBody TaskQueryParamsDro taskQueryParamsDro);

    /**
     * 更新账单数据保存
     * @param contractId 合同Id
     * @return void
     */
    @GetMapping("/updateSave")
    @ApiOperation(value = "更新账单数据保存", notes = "更新账单数据保存")
    RestResponse<Void> updateSave(@RequestParam(value = "contractId") Long contractId);

    /**
     * 根据出库时间与出库结果单号获取分拣费用数据
     *
     * @param outWarehouseTime 出库时间
     * @param documentNo 出库结果单号
     * @return void
     */
    @GetMapping("/getSortingExpenseByOutWarehouseTimeAndDocumentNo")
    @ApiOperation(value = "更新账单数据保存", notes = "更新账单数据保存")
    RestResponse<SortingExpenseRespDto> getSortingExpenseByOutWarehouseTimeAndDocumentNo(
            @RequestParam(value = "outWarehouseTime") String outWarehouseTime,
            @RequestParam(value = "documentNo") String documentNo,
            @RequestParam(value = "goodsLongCode") String goodsLongCode);

    /**
     * 导入调整分拣费用
     * @param updateList 导入数据
     * @return void
     */
    @PostMapping("/bathImportUpdate")
    @ApiOperation(value = "导入调整分拣费用", notes = "导入调整分拣费用")
    RestResponse<Void> bathImportUpdate(@RequestBody List<SortingExpenseReqDto> updateList);


    /**
     *  查询分拣费报表
     * @param queryDtoList
     * @return
     */
    @PostMapping("/getSortingExpenseByList")
    @ApiOperation(value = "更新账单数据保存", notes = "更新账单数据保存")
    RestResponse<List<SortingExpenseRespDto>> getSortingExpenseByList(@RequestBody List<SortingExpenseQueryDto> queryDtoList);

    /**
     *  分拣费用-编辑
     * @param reqDto
     * @return
     */
    @PostMapping("/edit")
    @ApiOperation(value = "分拣费用-编辑", notes = "分拣费用-编辑")
    RestResponse<Void> edit(@RequestBody SortingExpenseReqDto reqDto);

    @PostMapping("/querySortingCount")
    @ApiOperation(value = "分拣费用报表统计数据", notes = "分拣费用报表统计数据")
    RestResponse<ReInsuranceBillCountDto> querySortingCount(@RequestBody(required = false) SortingCostReportListPageReqDto sortingCostReportListPageReqDto);

    @PostMapping("/updateSortingExpense")
    @ApiOperation(value = "批量更新分拣费用数据", notes = "批量更新分拣费用数据")
    RestResponse<Void> updateSortingExpense(@RequestBody List<TaskQueryParamsDro> updateList);

    @PostMapping("/getByGroup")
    @ApiOperation(value = "根据条件查询", notes = "根据条件查询")
    RestResponse<SortingExpenseRespDto> getByGroup(@RequestBody SortingCostReportUpdateReqDto dto);

    /**
     * 分拣费用报表更新归档标识
     * @param updateReqDto
     * @return
     */
    @PostMapping("/updatePlaceStatus")
    @ApiOperation(value = "分拣费用报表更新归档标识", notes = "分拣费用报表更新归档标识")
    RestResponse<Integer> updatePlaceStatus(@RequestBody @Validated FeeReportPlaceUpdateReqDto updateReqDto);
}
