package com.dtyunxi.tcbj.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.ExpressCostReportPollNumDto;
import com.dtyunxi.tcbj.api.dto.request.AgainCalculateReqDto;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostConfigReqDto;
import com.dtyunxi.tcbj.api.dto.request.ExpressCostDetailReqDto;
import com.dtyunxi.tcbj.api.dto.request.LogisticStatisticReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * 快递费用计费配置服务接口
 * @author jiejun
 */
@Api(tags = {"快递费用计费配置服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-IExpressCostConfigApi",
        name = "${tcbj.center.report.api.name:tcbj-center-report}",
        path = "/v1/expressCostConfig",
        url = "${tcbj.center.report.api:}"
)
public interface IExpressCostConfigApi {


    @PostMapping("/modifyDifferenceValue")
    @ApiOperation(value = "修改差异值", notes = "修改差异值")
    RestResponse<Void> modifyDifferenceValue(@RequestBody ExpressCostConfigReqDto reqDto);
}
